/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.calendar.notification.user.AbstractCalendarUserNotificationBuilder;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;

abstract class AbstractCalendarEventUserNotificationBuilder
extends AbstractCalendarUserNotificationBuilder<PlannedOnCalendar> {
    private final NotifAction notificationCause;
    private CalendarOperation operation = CalendarOperation.NONE;
    private User sender;
    private boolean immediately = false;

    AbstractCalendarEventUserNotificationBuilder(PlannedOnCalendar calendarComponent, NotifAction action) {
        super(calendarComponent, null);
        this.notificationCause = action;
    }

    public AbstractCalendarEventUserNotificationBuilder about(CalendarOperation operation) {
        this.operation = operation;
        return this;
    }

    public AbstractCalendarEventUserNotificationBuilder from(User sender) {
        this.sender = sender;
        return this;
    }

    public AbstractCalendarEventUserNotificationBuilder immediately() {
        this.immediately = true;
        return this;
    }

    @Override
    protected boolean isSendImmediately() {
        return this.immediately;
    }

    @Override
    protected void performTemplateData(LocalizedContribution contribution, SilverpeasTemplate template) {
        String language = contribution.getLanguage();
        CalendarComponent component = ((PlannedOnCalendar)this.getResource()).asCalendarComponent();
        if (component != null) {
            template.setAttribute("contributionStartDate", (Object)this.startDateOf(component, language));
            if (component.getPeriod().spanOverSeveralDays()) {
                template.setAttribute("contributionEndDate", (Object)this.endDateOf(component, language));
            }
        }
        template.setAttribute("several", (Object)this.operation.isSeveralImplied());
    }

    @Override
    protected String getTemplateFileName() {
        return this.operation.getTemplateName();
    }

    @Override
    protected String getSender() {
        return this.sender.getId();
    }

    @Override
    protected NotifAction getAction() {
        return this.notificationCause;
    }

    private String startDateOf(@NonNull CalendarComponent calendarComponent, @NonNull String language) {
        Temporal startDate = CalendarEventUtil.getDateWithOffset(calendarComponent, calendarComponent.getPeriod().getStartDate());
        if (startDate instanceof LocalDate) {
            return ((LocalDate)startDate).format(DateTimeFormatter.ofPattern(DateUtil.getDateOutputFormat((String)language).getPattern()));
        }
        return ((OffsetDateTime)startDate).format(DateTimeFormatter.ofPattern(DateUtil.getDateOutputFormat((String)language).getPattern() + " " + DateUtil.getHourOutputFormat((String)language).getPattern())) + " (" + calendarComponent.getCalendar().getZoneId() + ")";
    }

    private String endDateOf(@NonNull CalendarComponent calendarComponent, @NonNull String language) {
        if (calendarComponent.getPeriod().isInDays()) {
            LocalDate endDate = ((LocalDate)CalendarEventUtil.getDateWithOffset(calendarComponent, calendarComponent.getPeriod().getEndDate())).minusDays(1L);
            return endDate.format(DateTimeFormatter.ofPattern(DateUtil.getDateOutputFormat((String)language).getPattern()));
        }
        OffsetDateTime endDateTime = (OffsetDateTime)CalendarEventUtil.getDateWithOffset(calendarComponent, calendarComponent.getPeriod().getEndDate());
        return endDateTime.format(DateTimeFormatter.ofPattern(DateUtil.getDateOutputFormat((String)language).getPattern() + " " + DateUtil.getHourOutputFormat((String)language).getPattern())) + " (" + calendarComponent.getCalendar().getZoneId() + ")";
    }

    protected CalendarOperation getOperation() {
        return this.operation;
    }
}

