/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.sql.Connection;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.persistence.GroupUserRoleRow;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.dao.GroupDAO;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.admin.user.model.GroupProfileInst;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional(value=Transactional.TxType.MANDATORY)
public class GroupProfileInstManager {
    public static final String GROUP_PROFILE = "group profile";
    @Inject
    private OrganizationSchema organizationSchema;
    @Inject
    private GroupDAO groupDAO;
    @Inject
    private UserDAO userDAO;

    protected GroupProfileInstManager() {
    }

    public String createGroupProfileInst(GroupProfileInst groupProfileInst, String sgroupId) throws AdminException {
        try {
            int nI;
            GroupUserRoleRow newRole = this.makeGroupUserRoleRow(groupProfileInst);
            newRole.groupId = this.idAsInt(sgroupId);
            this.organizationSchema.groupUserRole().createGroupUserRole(newRole);
            String sProfileId = GroupProfileInstManager.idAsString(newRole.id);
            for (nI = 0; nI < groupProfileInst.getNumGroup(); ++nI) {
                this.organizationSchema.groupUserRole().addGroupInGroupUserRole(this.idAsInt(groupProfileInst.getGroup(nI)), this.idAsInt(sProfileId));
            }
            for (nI = 0; nI < groupProfileInst.getNumUser(); ++nI) {
                this.organizationSchema.groupUserRole().addUserInGroupUserRole(this.idAsInt(groupProfileInst.getUser(nI)), this.idAsInt(sProfileId));
            }
            return sProfileId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP_PROFILE, (Object)groupProfileInst.getName()), e);
        }
    }

    public GroupProfileInst getGroupProfileInst(String groupId, boolean includeRemovedUsersAndGroups) throws AdminException {
        GroupProfileInst groupProfileInst = new GroupProfileInst();
        try (Connection connection = DBUtil.openConnection();){
            GroupUserRoleRow groupUserRole = this.organizationSchema.groupUserRole().getGroupUserRoleByGroupId(this.idAsInt(groupId));
            groupProfileInst.setGroupId(groupId);
            if (groupUserRole != null) {
                groupProfileInst.setId(Integer.toString(groupUserRole.id));
                groupProfileInst.setName(groupUserRole.roleName);
                String profileId = groupProfileInst.getId();
                this.groupDAO.getDirectGroupIdsByGroupUserRole(connection, profileId, includeRemovedUsersAndGroups).forEach(groupProfileInst::addGroup);
                this.userDAO.getDirectUserIdsByGroupUserRole(connection, profileId, includeRemovedUsersAndGroups).forEach(groupProfileInst::addUser);
            }
        }
        catch (Exception e) {
            throw new AdminException("Fail to set profile " + groupProfileInst.getId() + " to group " + groupId, e);
        }
        return groupProfileInst;
    }

    public void deleteGroupProfileInst(GroupProfileInst groupProfileInst) throws AdminException {
        try {
            int nI;
            for (nI = 0; nI < groupProfileInst.getNumGroup(); ++nI) {
                this.organizationSchema.groupUserRole().removeGroupFromGroupUserRole(this.idAsInt(groupProfileInst.getGroup(nI)), this.idAsInt(groupProfileInst.getId()));
            }
            for (nI = 0; nI < groupProfileInst.getNumUser(); ++nI) {
                this.organizationSchema.groupUserRole().removeUserFromGroupUserRole(this.idAsInt(groupProfileInst.getUser(nI)), this.idAsInt(groupProfileInst.getId()));
            }
            this.organizationSchema.groupUserRole().removeGroupUserRole(this.idAsInt(groupProfileInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP_PROFILE, (Object)groupProfileInst.getId()), e);
        }
    }

    public String updateGroupProfileInst(GroupProfileInst groupProfileInst, GroupProfileInst groupProfileInstNew) throws AdminException {
        try {
            List<String> alOldProfileGroup = groupProfileInst.getAllGroups();
            List<String> alNewProfileGroup = groupProfileInstNew.getAllGroups();
            for (String anAlNewProfileGroup : alNewProfileGroup) {
                if (alOldProfileGroup.contains(anAlNewProfileGroup)) continue;
                this.organizationSchema.groupUserRole().addGroupInGroupUserRole(this.idAsInt(anAlNewProfileGroup), this.idAsInt(groupProfileInst.getId()));
            }
            for (String anAlRemGroup : alOldProfileGroup) {
                if (alNewProfileGroup.contains(anAlRemGroup)) continue;
                this.organizationSchema.groupUserRole().removeGroupFromGroupUserRole(this.idAsInt(anAlRemGroup), this.idAsInt(groupProfileInst.getId()));
            }
            List<String> alOldProfileUser = groupProfileInst.getAllUsers();
            List<String> alNewProfileUser = groupProfileInstNew.getAllUsers();
            for (String anAlAddUser : alNewProfileUser) {
                if (alOldProfileUser.contains(anAlAddUser)) continue;
                this.organizationSchema.groupUserRole().addUserInGroupUserRole(this.idAsInt(anAlAddUser), this.idAsInt(groupProfileInst.getId()));
            }
            for (String anAlRemUser : alOldProfileUser) {
                if (alNewProfileUser.contains(anAlRemUser)) continue;
                this.organizationSchema.groupUserRole().removeUserFromGroupUserRole(this.idAsInt(anAlRemUser), this.idAsInt(groupProfileInst.getId()));
            }
            return groupProfileInst.getId();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP_PROFILE, (Object)groupProfileInst.getId()), e);
        }
    }

    private GroupUserRoleRow makeGroupUserRoleRow(GroupProfileInst groupProfileInst) {
        GroupUserRoleRow groupUserRole = new GroupUserRoleRow();
        groupUserRole.id = this.idAsInt(groupProfileInst.getId());
        groupUserRole.roleName = groupProfileInst.getName();
        return groupUserRole;
    }

    private int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

