/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class DomainCache {
    private ConcurrentMap<String, Domain> map = new ConcurrentHashMap<String, Domain>();

    protected DomainCache() {
    }

    public synchronized void clearCache() {
        this.map.clear();
    }

    public Optional<Domain> getDomain(String id) {
        return Optional.ofNullable((Domain)this.map.get(id));
    }

    public void setDomains(List<Domain> domains) {
        this.clearCache();
        for (Domain domain : domains) {
            this.addDomain(domain);
        }
    }

    public Domain addDomain(Domain domain) {
        Objects.requireNonNull(domain);
        return this.map.putIfAbsent(domain.getId(), domain);
    }

    public void removeDomain(String id) {
        this.map.remove(id);
    }
}

