/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.controls.LDAPPagedResultsControl;
import com.novell.ldap.controls.LDAPPagedResultsResponse;
import com.novell.ldap.controls.LDAPSortControl;
import com.novell.ldap.controls.LDAPSortKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPConnectInfo;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSearchContext;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSearchQuery;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSettings;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPUtility {
    private static final MessageFormat LDAP_ERROR = new MessageFormat("LDAP Error #{0}: {1}");
    private static final int MAX_NB_RETRY_CONNECT = 10;
    private static final String BASEDN_SEPARATOR = ";;";
    private static final Map<String, LDAPConnectInfo> connectInfos = new HashMap<String, LDAPConnectInfo>();
    private static final String LDAPUTILITY_SEARCH1000_PLUS = "LDAPUtility.search1000Plus()";
    private static int connexionsLastId = 0;

    private LDAPUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String openConnection(LDAPSettings driverSettings) throws AdminException {
        String newId;
        Map<String, LDAPConnectInfo> map = connectInfos;
        synchronized (map) {
            newId = Integer.toString(connexionsLastId);
            if (++connexionsLastId > 1000000) {
                connexionsLastId = 0;
            }
        }
        connectInfos.put(newId, new LDAPConnectInfo(driverSettings));
        LDAPUtility.internalOpenConnection(newId);
        return newId;
    }

    public static LDAPConnection getConnection(String connectionId) {
        return connectInfos.get(connectionId).getConnection();
    }

    private static boolean recoverConnection(String connectionId, LDAPException ex) {
        int nbRetry = 0;
        boolean reOpened = false;
        if (ex.getResultCode() == 91 && connectInfos.get(connectionId).incErrorCpt()) {
            SilverLogger.getLogger(LDAPUtility.class).warn("LDAP connection {0} lost", new Object[]{connectionId});
            try {
                LDAPUtility.internalCloseConnection(connectionId);
            }
            catch (AdminException e) {
                SilverLogger.getLogger(LDAPUtility.class).warn((Throwable)((Object)e));
            }
            while (!reOpened && nbRetry < 10) {
                try {
                    LDAPUtility.sleepCurrentThread();
                    LDAPUtility.internalOpenConnection(connectionId);
                    reOpened = true;
                }
                catch (AdminException e) {
                    SilverLogger.getLogger(LDAPUtility.class).warn("Error in retry " + ++nbRetry + ": " + e.getMessage(), new Object[0]);
                }
            }
        }
        return reOpened;
    }

    private static void sleepCurrentThread() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void closeConnection(String connectionId) throws AdminException {
        LDAPUtility.internalCloseConnection(connectionId);
        connectInfos.remove(connectionId);
    }

    private static void internalOpenConnection(String connectionId) throws AdminException {
        LDAPSettings driverSettings = connectInfos.get(connectionId).getSettings();
        LDAPConnection ldapConnection = driverSettings.isLDAPSecured() ? new LDAPConnection((LDAPSocketFactory)new LDAPJSSESecureSocketFactory()) : new LDAPConnection();
        try {
            ldapConnection.connect(driverSettings.getLDAPHost(), driverSettings.getLDAPPort());
            byte[] passwd = driverSettings.getLDAPAccessPasswd();
            ldapConnection.bind(driverSettings.getLDAPProtocolVer(), driverSettings.getLDAPAccessLoginDN(), passwd);
            ldapConnection.setConstraints((LDAPConstraints)driverSettings.getSearchConstraints(false));
            connectInfos.get(connectionId).setConnection(ldapConnection);
        }
        catch (LDAPException e) {
            try {
                ldapConnection.disconnect();
            }
            catch (LDAPException ee) {
                SilverLogger.getLogger(LDAPUtility.class).error("Error while closing connection " + connectionId + ". Error LDAP #" + e.getResultCode() + " " + e.getLDAPErrorMessage(), (Throwable)ee);
            }
            throw new AdminException("Connection error with Host : " + driverSettings.getLDAPHost() + " Port : " + driverSettings.getLDAPPort() + " LDAPLogin : " + driverSettings.getLDAPAccessLoginDN() + " ProtocolVer : " + driverSettings.getLDAPProtocolVer(), e);
        }
    }

    private static void internalCloseConnection(String connectionId) throws AdminException {
        LDAPConnection toClose = LDAPUtility.getConnection(connectionId);
        if (toClose != null && toClose.isConnected()) {
            try {
                toClose.disconnect();
            }
            catch (LDAPException e) {
                throw new AdminException("Fail to close connection " + connectionId + ". " + LDAP_ERROR.format(new Object[]{Integer.toString(e.getResultCode()), e.getLDAPErrorMessage()}), e);
            }
        }
    }

    public static String getFirstAttributeValue(LDAPEntry theEntry, String attributeName) {
        String[] values = LDAPUtility.getAttributeValues(theEntry, attributeName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return "";
    }

    public static LDAPEntry getFirstEntryFromSearch(String lds, String baseDN, int scope, String filter, String[] attrs) throws AdminException {
        return LDAPUtility.getEntriesFromSearch(lds, baseDN, scope, filter, attrs, true).stream().findFirst().orElse(null);
    }

    public static List<LDAPEntry> getEntriesFromSearch(String lds, String baseDN, int scope, String filter, String[] attrs) throws AdminException {
        return LDAPUtility.getEntriesFromSearch(lds, baseDN, scope, filter, attrs, false);
    }

    private static List<LDAPEntry> getEntriesFromSearch(String lds, String baseDN, int scope, String filter, String[] attrs, boolean firstOnly) throws AdminException {
        LDAPConnection connection = LDAPUtility.getConnection(lds);
        String sureFilter = Optional.ofNullable(filter).filter(StringUtil::isDefined).orElse("(objectClass=*)");
        LDAPSearchConstraints sc = connection.getSearchConstraints();
        Optional.of(firstOnly).filter(Boolean.TRUE::equals).ifPresentOrElse(b -> {
            sc.setBatchSize(1);
            sc.setMaxResults(1);
        }, () -> {
            sc.setBatchSize(1500);
            sc.setMaxResults(1500);
        });
        String[] baseDNs = LDAPUtility.extractBaseDNs(baseDN);
        ArrayList<LDAPEntry> entries = new ArrayList<LDAPEntry>();
        for (String baseDN1 : baseDNs) {
            try {
                LDAPSearchResults res = connection.search(baseDN1, scope, sureFilter, attrs, false, sc);
                while (res.hasMore()) {
                    entries.add(res.next());
                    if (!firstOnly) continue;
                    return entries;
                }
            }
            catch (LDAPReferralException re) {
                throw new AdminException(LDAP_ERROR.format(new Object[]{Integer.toString(re.getResultCode()), re.getLDAPErrorMessage()}), re);
            }
            catch (LDAPException e) {
                if (LDAPUtility.recoverConnection(lds, e)) {
                    return LDAPUtility.getEntriesFromSearch(lds, baseDN, scope, filter, attrs, firstOnly);
                }
                SilverLogger.getLogger(LDAPUtility.class).error("Error LDAP #" + e.getResultCode() + " " + e.getLDAPErrorMessage(), (Throwable)e);
            }
        }
        return entries;
    }

    static boolean isAGuid(String attName) {
        return "objectGUID".equalsIgnoreCase(attName) || "GUID".equalsIgnoreCase(attName);
    }

    static String[] getAttributeValues(LDAPEntry theEntry, String theAttributeName) {
        if (theEntry == null || !StringUtil.isDefined((String)theAttributeName)) {
            return ArrayUtil.emptyStringArray();
        }
        LDAPAttribute theAttr = theEntry.getAttribute(theAttributeName);
        if (theAttr == null) {
            return ArrayUtil.emptyStringArray();
        }
        if (LDAPUtility.isAGuid(theAttributeName)) {
            byte[][] allBytes = theAttr.getByteValueArray();
            String[] valret = new String[theAttr.size()];
            for (int j = 0; j < theAttr.size(); ++j) {
                StringBuilder theStr = new StringBuilder(50);
                byte[] asBytes = allBytes[j];
                LDAPUtility.decodeBytesAttributeValue(asBytes, theStr);
                valret[j] = theStr.toString();
            }
            return valret;
        }
        return theAttr.getStringValueArray();
    }

    private static void decodeBytesAttributeValue(byte[] asBytes, StringBuilder theStr) {
        for (byte asByte : asBytes) {
            String asString = Integer.toHexString(asByte);
            if (asString.length() > 3) {
                theStr.append("\\\\").append(asString.substring(6));
                continue;
            }
            if (asString.length() == 1) {
                theStr.append("\\\\0").append(asString);
                continue;
            }
            theStr.append("\\\\").append(asString);
        }
    }

    public static String dblBackSlashesForDNInFilters(String theDN) {
        return LDAPUtility.escapeDN(theDN);
    }

    public static String normalizeFilterValue(String theFilter) {
        return LDAPUtility.escapeLDAPSearchFilter(theFilter);
    }

    static String escapeDN(String name) {
        StringBuilder sb = new StringBuilder();
        if (!(name.isEmpty() || name.charAt(0) != ' ' && name.charAt(0) != '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    static String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block8;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block8;
                }
                case '%': {
                    sb.append("*");
                    continue block8;
                }
                case '(': {
                    sb.append("\\28");
                    continue block8;
                }
                case ')': {
                    sb.append("\\29");
                    continue block8;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block8;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString().replace("\\5c*", "%");
    }

    static String unescapeLDAPSearchFilter(String filter) {
        String unescapedFilter = filter;
        unescapedFilter = unescapedFilter.replace("\\5c", "\\");
        unescapedFilter = unescapedFilter.replace("\\2a", "*");
        unescapedFilter = unescapedFilter.replace("\\28", "(");
        unescapedFilter = unescapedFilter.replace("\\29", ")");
        unescapedFilter = unescapedFilter.replace("\\00", "\u0000");
        return unescapedFilter;
    }

    static LDAPEntry[] search1000Plus(String lds, String baseDN, int scope, String filter, String varToSort, String[] args) throws AdminException {
        LDAPConnection ld = LDAPUtility.getConnection(lds);
        ArrayList<LDAPEntry> ldapEntries = new ArrayList<LDAPEntry>();
        try {
            String[] baseDNs;
            LDAPSettings driverSettings = connectInfos.get(lds).getSettings();
            for (String baseDN1 : baseDNs = LDAPUtility.extractBaseDNs(baseDN)) {
                LDAPSearchConstraints constraints = ld.getSearchConstraints();
                ArrayList<Object> ldapControls = new ArrayList<Object>(2);
                ldapControls.add(new LDAPPagedResultsControl(constraints.getMaxResults(), false));
                if (driverSettings.isSortControlSupported()) {
                    ldapControls.add(new LDAPSortControl(new LDAPSortKey(varToSort), false));
                }
                constraints.setControls(ldapControls.toArray(new LDAPControl[0]));
                LDAPSearchContext context = new LDAPSearchContext().setVarToSort(varToSort);
                LDAPSearchQuery query = new LDAPSearchQuery().setScope(scope).setAttrs(args).setConstraints(constraints);
                query.setBaseDN(baseDN1);
                query.setFilter(filter);
                while (query.getFilter() != null) {
                    SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "Requ\u00eate sur le domaine LDAP distant (protocole v" + ld.getProtocolVersion() + "), BaseDN=" + baseDN1 + " scope=" + scope + " Filter=" + query.getFilter());
                    LDAPUtility.internalLdapSearch(ld, query, context, ldapEntries);
                }
            }
        }
        catch (LDAPReferralException re) {
            SynchroDomainReport.error(LDAPUTILITY_SEARCH1000_PLUS, "R\u00e9f\u00e9rence (referral) retourn\u00e9e mais pas suivie !", re);
            throw new AdminException(LDAP_ERROR.format(new Object[]{Integer.toString(re.getResultCode()), re.getLDAPErrorMessage()}), re);
        }
        catch (LDAPException e) {
            SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "Une exception g\u00e9n\u00e9rale est survenue : #" + e.getResultCode() + " " + e.getLDAPErrorMessage());
            if (LDAPUtility.recoverConnection(lds, e)) {
                return LDAPUtility.search1000Plus(lds, baseDN, scope, filter, varToSort, args);
            }
            throw new AdminException(LDAP_ERROR.format(new Object[]{Integer.toString(e.getResultCode()), e.getLDAPErrorMessage()}), e);
        }
        return ldapEntries.toArray(new LDAPEntry[0]);
    }

    private static void internalLdapSearch(LDAPConnection ld, LDAPSearchQuery query, LDAPSearchContext context, List<LDAPEntry> results) throws LDAPException {
        LDAPEntry entry = null;
        LDAPSearchResults res = null;
        try {
            res = ld.search(query.getBaseDN(), query.getScope(), query.getFilter(), query.getAttrs(), false, query.getConstraints());
            while (res.hasMore()) {
                entry = res.next();
                if (context.isNotTheFirst()) {
                    context.setNotTheFirst(false);
                    continue;
                }
                SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "\u00e9l\u00e9ment #" + context.getNbReaded() + " : " + entry.getDN());
                results.add(entry);
                context.incNbReaded();
            }
        }
        catch (LDAPException le) {
            if (le.getResultCode() == 4) {
                context.setSizeLimitReached(true);
                SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "Size Limit Reached...");
            }
            if (le.getResultCode() == 3) {
                context.setTimeLimitReached(true).incNbRetryTimeLimit().setLastException(le);
                SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "Time Limit Reached (#" + context.getNbRetryLimit() + ")");
            }
            SilverLogger.getLogger(LDAPUtility.class).error("Error LDAP #" + le.getResultCode() + " " + le.getLDAPErrorMessage(), (Throwable)le);
            throw le;
        }
        if (context.isSizeLimitReached() || context.isTimeLimitReached() && context.isNotMaxNbRetryTimeLimitReached()) {
            context.setNotTheFirst(true).setSizeLimitReached(false).setTimeLimitReached(false);
            query.setFilter("(&" + query.getFilter() + "(" + context.getVarToSort() + ">=" + LDAPUtility.getFirstAttributeValue(entry, context.getVarToSort()) + "))");
        } else {
            if (context.isTimeLimitReached() && context.isMaxNbRetryTimeLimitReached()) {
                throw context.getLastException();
            }
            LDAPUtility.setupNextPagedQuery(query, context, res, results);
        }
    }

    private static void setupNextPagedQuery(LDAPSearchQuery query, LDAPSearchContext context, LDAPSearchResults searchResults, List<LDAPEntry> results) {
        LDAPSearchConstraints constraints = query.getConstraints();
        LDAPPagedResultsResponse pagedResults = Optional.ofNullable(searchResults).map(LDAPSearchResults::getResponseControls).stream().flatMap(Arrays::stream).filter(LDAPPagedResultsResponse.class::isInstance).map(LDAPPagedResultsResponse.class::cast).findFirst().orElse(null);
        if (pagedResults == null) {
            query.setFilter(null);
        } else {
            List<LDAPControl> ldapControls = Arrays.stream(constraints.getControls()).filter(Predicate.not(LDAPPagedResultsControl.class::isInstance)).collect(Collectors.toList());
            if (pagedResults.isCritical()) {
                String warn = "Paged result is not handled, retrying without page result control";
                SilverLogger.getLogger(LDAPUtility.class).warn("Paged result is not handled, retrying without page result control", new Object[0]);
                SynchroDomainReport.debug(LDAPUTILITY_SEARCH1000_PLUS, "Paged result is not handled, retrying without page result control");
                results.clear();
                ldapControls = ldapControls.stream().map(c -> {
                    if (c instanceof LDAPSortControl) {
                        return new LDAPSortControl(new LDAPSortKey(context.getVarToSort()), true);
                    }
                    return c;
                }).collect(Collectors.toList());
            } else {
                byte[] cookie = pagedResults.getCookie();
                if (ArrayUtil.isEmpty(cookie)) {
                    query.setFilter(null);
                } else {
                    ldapControls.add((LDAPControl)new LDAPPagedResultsControl(constraints.getMaxResults(), cookie, false));
                }
            }
            constraints.setControls(ldapControls.toArray(new LDAPControl[0]));
        }
    }

    static String[] extractBaseDNs(String baseDN) {
        if (!StringUtil.isDefined((String)baseDN) || !baseDN.contains(BASEDN_SEPARATOR)) {
            String[] baseDNs = new String[1];
            if (baseDN == null) {
                baseDN = "";
            }
            baseDNs[0] = baseDN;
            return baseDNs;
        }
        StringTokenizer st = new StringTokenizer(baseDN, BASEDN_SEPARATOR);
        ArrayList<String> baseDNs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            baseDNs.add(st.nextToken());
        }
        return baseDNs.toArray(new String[0]);
    }
}

