/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class ComponentSelection
extends ClipboardSelection
implements Serializable {
    private static final long serialVersionUID = 4750709802063183409L;
    private static final String TYPE = "Component";
    public static final DataFlavor ComponentDetailFlavor = new DataFlavor(ComponentInst.class, "Component");
    private final ComponentInst componentInst;

    public ComponentSelection(ComponentInst component) {
        this.componentInst = component;
        super.addFlavor(ComponentDetailFlavor);
    }

    @Override
    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferredData;
        try {
            transferredData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (ComponentDetailFlavor.equals(parFlavor)) {
                transferredData = this.componentInst;
            }
            throw e;
        }
        return transferredData;
    }

    @Override
    public IndexEntry getIndexEntry() {
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(this.componentInst.getId(), TYPE, this.componentInst.getId()));
        indexEntry.setTitle(this.componentInst.getLabel());
        return indexEntry;
    }

    @Override
    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.componentInst.getId());
        keyData.setTitle(this.componentInst.getLabel());
        keyData.setAuthor(this.componentInst.getCreatorUserId());
        keyData.setCreationDate(this.componentInst.getCreationDate());
        keyData.setDesc(this.componentInst.getDescription());
        keyData.setType(TYPE);
        keyData.setLink(URLUtil.getSimpleURL(1, this.componentInst.getId()));
        try {
            keyData.setProperty("COMPONENT_NAME", ComponentInst.getComponentName(this.componentInst.getId()));
        }
        catch (SKDException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
        return keyData;
    }
}

