/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.core.util.MemoizedSupplier;

public class RequestValidationCriteria {
    private final String validatorId;
    private final MemoizedSupplier<Set<String>> managedDomainUsersSupplier;
    private boolean skipValidationFiltering = false;
    private boolean avoidValidatedByValidator = false;
    private boolean stillNeedValidation = false;
    private boolean invert = false;
    private boolean orNoValidator = false;
    private boolean orValidatorIsHierarchicalOne = false;
    private final Set<FormInstanceValidationType> orLastValidationType = new TreeSet<FormInstanceValidationType>();

    public RequestValidationCriteria(String validatorId, MemoizedSupplier<Set<String>> managedDomainUsersSupplier) {
        this.validatorId = validatorId;
        this.managedDomainUsersSupplier = managedDomainUsersSupplier;
    }

    public static RequestValidationCriteria withValidatorId(String validatorId, MemoizedSupplier<Set<String>> managedDomainUsersSupplier) {
        return new RequestValidationCriteria(validatorId, managedDomainUsersSupplier);
    }

    public RequestValidationCriteria orLastValidationType(FormInstanceValidationType ... states) {
        return this.orLastValidationType(Stream.of(states).collect(Collectors.toList()));
    }

    public RequestValidationCriteria orLastValidationType(Collection<FormInstanceValidationType> validationTypes) {
        this.orLastValidationType.addAll(validationTypes);
        return this;
    }

    public RequestValidationCriteria orValidatorIsHierarchicalOne() {
        this.orValidatorIsHierarchicalOne = true;
        return this;
    }

    public RequestValidationCriteria orNoValidator() {
        this.orNoValidator = true;
        return this;
    }

    public RequestValidationCriteria andStillNeedValidation() {
        this.stillNeedValidation = true;
        return this;
    }

    public RequestValidationCriteria invert() {
        this.invert = true;
        return this;
    }

    public RequestValidationCriteria andAvoidValidatedByValidator() {
        this.avoidValidatedByValidator = true;
        return this;
    }

    public void skipValidationFiltering() {
        this.skipValidationFiltering = true;
    }

    String getValidatorId() {
        return this.validatorId;
    }

    boolean isOrNoValidator() {
        return this.orNoValidator;
    }

    boolean isOrValidatorIsHierarchicalOne() {
        return this.orValidatorIsHierarchicalOne;
    }

    Set<String> getManagedDomainUsers() {
        if (!this.orValidatorIsHierarchicalOne) {
            return Collections.emptySet();
        }
        return (Set)this.managedDomainUsersSupplier.get();
    }

    Set<FormInstanceValidationType> getOrLastValidationType() {
        return this.orLastValidationType;
    }

    boolean isStillNeedValidation() {
        return this.stillNeedValidation;
    }

    boolean isInvert() {
        return this.invert;
    }

    boolean isAvoidValidatedByValidator() {
        return this.avoidValidatedByValidator;
    }

    boolean isSkipValidationFiltering() {
        return this.skipValidationFiltering;
    }

    public String toString() {
        return new StringJoiner(", ", RequestValidationCriteria.class.getSimpleName() + "[", "]").add("validatorId='" + this.validatorId + "'").add("skipValidationFiltering=" + this.skipValidationFiltering).add("avoidValidatedByValidator=" + this.avoidValidatedByValidator).add("stillNeedValidation=" + this.stillNeedValidation).add("invert=" + this.invert).add("orNoValidator=" + this.orNoValidator).add("orValidatorIsHierarchicalOne=" + this.orValidatorIsHierarchicalOne).add("orLastValidationType=" + this.orLastValidationType).toString();
    }
}

