/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql.setters;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlTypedParameterSetter;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class SqlBinaryParamSetter
implements SqlTypedParameterSetter {
    @Override
    public List<Class<?>> getSupportedTypes() {
        return Arrays.asList(Byte.class, Blob.class, Clob.class);
    }

    @Override
    public void setParameter(PreparedStatement statement, int idx, Object value) throws SQLException {
        if (value instanceof Byte) {
            statement.setByte(idx, (Byte)value);
        } else if (value instanceof Blob) {
            statement.setBlob(idx, (Blob)value);
        } else if (value instanceof Clob) {
            statement.setClob(idx, (Clob)value);
        } else {
            throw new IllegalArgumentException("Type not supported: " + value.getClass());
        }
    }
}

