/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence;

import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public interface ResourceBelonging {
    public String getResourceType();

    public String getResourceId();

    @Nullable
    default public <E, R extends EntityReference<E>> R getResource(Class<R> referenceClass) {
        EntityReference ref = null;
        String resourceType = this.getResourceType();
        String resourceId = this.getResourceId();
        if (resourceType != null && !resourceType.equals("UNKNOWN") && StringUtil.isDefined((String)resourceId)) {
            try {
                ref = (EntityReference)referenceClass.getConstructor(String.class).newInstance(resourceId);
                if (!ref.getType().equals(resourceType)) {
                    ref = null;
                }
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
        }
        return (R)ref;
    }
}

