/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;

public final class SaltedPasswordAlgorithmSpec
implements AlgorithmParameterSpec,
Serializable {
    private static final long serialVersionUID = 2106649716615705081L;
    private final byte[] salt;

    public SaltedPasswordAlgorithmSpec(byte[] salt) {
        Assert.checkNotNullParam("salt", salt);
        this.salt = salt;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SaltedPasswordAlgorithmSpec)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        SaltedPasswordAlgorithmSpec otherSpec = (SaltedPasswordAlgorithmSpec)other;
        return Arrays.equals(this.salt, otherSpec.salt);
    }

    public int hashCode() {
        return Arrays.hashCode(this.salt);
    }
}

