/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.Objects;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.ToGraphable;

class InternalStages {
    private InternalStages() {
    }

    static InternalStage nested(Object object) {
        Objects.requireNonNull(object);
        if (object instanceof ReactiveStreamsGraphBuilder) {
            return new Nested((ReactiveStreamsGraphBuilder)object);
        }
        if (object instanceof ToGraphable) {
            return new NestedGraph(((ToGraphable)object).toGraph());
        }
        throw new IllegalArgumentException("The passed in builder does not implement " + ToGraphable.class + " and so can't be added to this graph");
    }

    static final class NestedGraph
    implements InternalStage {
        private final Graph graph;

        NestedGraph(Graph graph) {
            this.graph = graph;
        }

        public Graph getGraph() {
            return this.graph;
        }
    }

    static final class Nested
    implements InternalStage {
        private final ReactiveStreamsGraphBuilder graphBuilder;

        Nested(ReactiveStreamsGraphBuilder graphBuilder) {
            this.graphBuilder = graphBuilder;
        }

        ReactiveStreamsGraphBuilder getBuilder() {
            return this.graphBuilder;
        }
    }

    static final class Identity
    implements InternalStage {
        static final Identity INSTANCE = new Identity();

        private Identity() {
        }
    }

    static interface InternalStage
    extends Stage {
    }
}

