/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EJBSecurityDomainService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.ApplicationSecurityDomainConfig;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SecurityDomain;

public class EJBDefaultSecurityDomainProcessor
implements DeploymentUnitProcessor {
    private volatile String defaultSecurityDomainName;
    private volatile Function<String, ApplicationSecurityDomainConfig> knownSecurityDomain;
    private volatile BooleanSupplier outflowSecurityDomainsConfigured;

    public EJBDefaultSecurityDomainProcessor(String defaultSecurityDomainName, Function<String, ApplicationSecurityDomainConfig> knownSecurityDomain, BooleanSupplier outflowSecurityDomainsConfigured) {
        this.defaultSecurityDomainName = defaultSecurityDomainName;
        this.knownSecurityDomain = knownSecurityDomain;
        this.outflowSecurityDomainsConfigured = outflowSecurityDomainsConfigured;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block11: {
            ServiceName ejbSecurityDomainServiceName;
            ServiceName elytronDomainServiceName;
            Collection componentDescriptions;
            DeploymentUnit deploymentUnit;
            block10: {
                boolean useDefaultElytronMapping;
                deploymentUnit = phaseContext.getDeploymentUnit();
                EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                if (eeModuleDescription == null) {
                    return;
                }
                componentDescriptions = eeModuleDescription.getComponentDescriptions();
                if (componentDescriptions == null || componentDescriptions.isEmpty()) {
                    return;
                }
                String defaultSecurityDomain = eeModuleDescription.getDefaultSecurityDomain() == null ? this.defaultSecurityDomainName : eeModuleDescription.getDefaultSecurityDomain();
                CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
                SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
                elytronDomainServiceName = securityMetaData != null ? securityMetaData.getSecurityDomain() : null;
                ejbSecurityDomainServiceName = deploymentUnit.getServiceName().append(EJBSecurityDomainService.SERVICE_NAME);
                ApplicationSecurityDomainConfig defaultDomainMapping = this.knownSecurityDomain.apply(defaultSecurityDomain);
                ServiceName defaultElytronDomainServiceName = defaultDomainMapping != null ? support.getCapabilityServiceName("org.wildfly.ejb3.application-security-domain", new String[]{defaultSecurityDomain}).append(new String[]{"security-domain"}) : null;
                ApplicationSecurityDomainConfig selectedElytronDomainConfig = null;
                if (elytronDomainServiceName != null) break block10;
                String selectedElytronDomainName = null;
                boolean legacyDomainDefined = false;
                boolean defaultRequired = false;
                for (ComponentDescription componentDescription : componentDescriptions) {
                    ApplicationSecurityDomainConfig definedDomainMapping;
                    if (!(componentDescription instanceof EJBComponentDescription)) continue;
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                    ejbComponentDescription.setDefaultSecurityDomain(defaultSecurityDomain);
                    String definedSecurityDomain = ejbComponentDescription.getDefinedSecurityDomain();
                    defaultRequired = defaultRequired || definedSecurityDomain == null;
                    ApplicationSecurityDomainConfig applicationSecurityDomainConfig = definedDomainMapping = definedSecurityDomain != null ? this.knownSecurityDomain.apply(definedSecurityDomain) : null;
                    if (definedDomainMapping != null) {
                        if (selectedElytronDomainName == null) {
                            selectedElytronDomainName = definedSecurityDomain;
                            selectedElytronDomainConfig = definedDomainMapping;
                            continue;
                        }
                        if (selectedElytronDomainName.equals(definedSecurityDomain)) continue;
                        throw EjbLogger.ROOT_LOGGER.multipleSecurityDomainsDetected();
                    }
                    if (definedSecurityDomain == null) continue;
                    legacyDomainDefined = true;
                }
                if (defaultRequired && selectedElytronDomainName == null && defaultDomainMapping != null) {
                    selectedElytronDomainName = defaultSecurityDomain;
                    selectedElytronDomainConfig = defaultDomainMapping;
                    elytronDomainServiceName = defaultElytronDomainServiceName;
                    useDefaultElytronMapping = !legacyDomainDefined;
                } else {
                    useDefaultElytronMapping = false;
                }
                if (selectedElytronDomainConfig == null) break block11;
                EJBSecurityDomainService ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
                ServiceName applicationSecurityDomainServiceName = support.getCapabilityServiceName("org.wildfly.ejb3.application-security-domain", new String[]{selectedElytronDomainName});
                elytronDomainServiceName = applicationSecurityDomainServiceName.append(new String[]{"security-domain"});
                ServiceBuilder builder = phaseContext.getServiceTarget().addService(ejbSecurityDomainServiceName, (Service)ejbSecurityDomainService).addDependency(applicationSecurityDomainServiceName, ApplicationSecurityDomainService.ApplicationSecurityDomain.class, ejbSecurityDomainService.getApplicationSecurityDomainInjector());
                builder.install();
                for (ComponentDescription componentDescription : componentDescriptions) {
                    if (!(componentDescription instanceof EJBComponentDescription)) continue;
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                    String definedSecurityDomain = ejbComponentDescription.getDefinedSecurityDomain();
                    if (useDefaultElytronMapping || selectedElytronDomainName.equals(definedSecurityDomain)) {
                        ejbComponentDescription.setOutflowSecurityDomainsConfigured(this.outflowSecurityDomainsConfigured);
                        ejbComponentDescription.setSecurityDomainServiceName(elytronDomainServiceName);
                        ejbComponentDescription.setRequiresJacc(selectedElytronDomainConfig.isEnableJacc());
                        ejbComponentDescription.setLegacyCompliantPrincipalPropagation(selectedElytronDomainConfig.isLegacyCompliantPrincipalPropagation());
                        ejbComponentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
                        continue;
                    }
                    if (definedSecurityDomain != null || defaultDomainMapping == null) continue;
                    ejbComponentDescription.setOutflowSecurityDomainsConfigured(this.outflowSecurityDomainsConfigured);
                    ejbComponentDescription.setSecurityDomainServiceName(defaultElytronDomainServiceName);
                    ejbComponentDescription.setRequiresJacc(defaultDomainMapping.isEnableJacc());
                    ejbComponentDescription.setLegacyCompliantPrincipalPropagation(defaultDomainMapping.isLegacyCompliantPrincipalPropagation());
                    ejbComponentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
                }
                break block11;
            }
            EJBSecurityDomainService ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
            ServiceBuilder builder = phaseContext.getServiceTarget().addService(ejbSecurityDomainServiceName, (Service)ejbSecurityDomainService).addDependency(elytronDomainServiceName, SecurityDomain.class, ejbSecurityDomainService.getSecurityDomainInjector());
            builder.install();
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof EJBComponentDescription)) continue;
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                ejbComponentDescription.setSecurityDomainServiceName(elytronDomainServiceName);
                ejbComponentDescription.setOutflowSecurityDomainsConfigured(this.outflowSecurityDomainsConfigured);
                componentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
            }
        }
    }

    public void setDefaultSecurityDomainName(String securityDomainName) {
        this.defaultSecurityDomainName = securityDomainName;
    }
}

