/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.deployment;

import java.util.List;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.transaction.Transactional;
import javax.ws.rs.Path;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.narayana.rest.bridge.inbound.EJBExceptionMapper;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeFilter;
import org.jboss.narayana.rest.bridge.inbound.TransactionalExceptionMapper;
import org.wildfly.extension.rts.jaxrs.ImportWildflyClientGlobalTransactionFilter;

public class InboundBridgeDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName PATH_DOT_NAME = DotName.createSimple((String)Path.class.getName());
    private static final DotName TRANSACTIONAL_DOT_NAME = DotName.createSimple((String)Transactional.class.getName());
    private static final DotName STATELESS_ATTRIBUTE_DOT_NAME = DotName.createSimple((String)Stateless.class.getName());
    private static final DotName STATEFUL_ATTRIBUTE_DOT_NAME = DotName.createSimple((String)Stateful.class.getName());
    private static final String[] PROVIDERS = new String[]{InboundBridgeFilter.class.getName(), ImportWildflyClientGlobalTransactionFilter.class.getName(), TransactionalExceptionMapper.class.getName(), EJBExceptionMapper.class.getName()};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (this.isBridgeRequired(deploymentUnit)) {
            this.registerProviders(deploymentUnit);
        }
    }

    private boolean isBridgeRequired(DeploymentUnit deploymentUnit) {
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            return false;
        }
        List pathAnnotations = index.getAnnotations(PATH_DOT_NAME);
        for (AnnotationInstance annotationInstance : pathAnnotations) {
            AnnotationTarget target = annotationInstance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            if (classInfo.annotations().get(TRANSACTIONAL_DOT_NAME) != null) {
                return true;
            }
            if (classInfo.annotations().get(STATELESS_ATTRIBUTE_DOT_NAME) == null && classInfo.annotations().get(STATEFUL_ATTRIBUTE_DOT_NAME) == null) continue;
            return true;
        }
        return false;
    }

    private void registerProviders(DeploymentUnit deploymentUnit) {
        ResteasyDeploymentData resteasyDeploymentData = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasyDeploymentData != null) {
            for (String provider : PROVIDERS) {
                resteasyDeploymentData.getScannedProviderClasses().add(provider);
            }
        }
    }
}

