/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Period;
import java.util.Locale;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PeriodBridge
implements TwoWayStringBridge,
IgnoreAnalyzerBridge {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int PADDING = 11;
    private static final String FORMAT = "%+011d%+011d%+011d";
    public static final PeriodBridge INSTANCE = new PeriodBridge();

    private PeriodBridge() {
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        Period period = (Period)object;
        int years = period.getYears();
        int months = period.getMonths();
        int days = period.getDays();
        return String.format(Locale.ROOT, FORMAT, years, months, days);
    }

    @Override
    public Object stringToObject(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            int years = Integer.parseInt(stringValue.substring(0, 11));
            int months = Integer.parseInt(stringValue.substring(11, 22));
            int days = Integer.parseInt(stringValue.substring(22));
            return Period.of(years, months, days);
        }
        catch (NumberFormatException e) {
            throw log.parseException(stringValue, Duration.class, e);
        }
    }
}

