/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.internal;

import java.lang.reflect.Method;
import java.util.concurrent.ForkJoinPool;
import org.infinispan.commons.dataconversion.MediaTypeResolver;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.internal.BlockHoundUtil;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CommonsBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(thread -> thread.getThreadGroup() instanceof NonBlockingResource));
        builder.markAsBlocking(BlockHoundUtil.class, "pretendBlock", "()V");
        builder.disallowBlockingCallsInside(NonBlockingRejectedExecutionHandler.class.getName(), "rejectedExecution");
        builder.allowBlockingCallsInside(SslContextFactory.class.getName(), "loadKeyStore");
        builder.allowBlockingCallsInside(SslContextFactory.class.getName(), "getContext");
        builder.allowBlockingCallsInside(MediaTypeResolver.class.getName(), "populateFileMap");
        builder.allowBlockingCallsInside(ServiceFinder.class.getName(), "load");
        builder.allowBlockingCallsInside("com.github.benmanes.caffeine.cache.BoundedLocalCache", "performCleanUp");
        CommonsBlockHoundIntegration.handleJREClasses(builder);
    }

    public static void allowPublicMethodsToBlock(BlockHound.Builder builder, Class<?> clazz) {
        CommonsBlockHoundIntegration.allowMethodsToBlock(builder, clazz, true);
    }

    public static void allowMethodsToBlock(BlockHound.Builder builder, Class<?> clazz, boolean publicOnly) {
        Method[] methods;
        for (Method method : methods = publicOnly ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            builder.allowBlockingCallsInside(clazz.getName(), method.getName());
        }
    }

    private static void handleJREClasses(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(ForkJoinPool.class.getName(), "runWorker");
        builder.disallowBlockingCallsInside(ForkJoinPool.class.getName(), "scan");
    }
}

