/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.marshaller;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.marshalling.MarshallerFactory;

public enum HotRodMarshallerFactory implements BiFunction<ModuleLoader, List<Module>, Marshaller>
{
    LEGACY{
        private final Set<String> protoStreamModules = Collections.singleton("org.wildfly.clustering.web.hotrod");
        private final Predicate<String> protoStreamPredicate = this.protoStreamModules::contains;

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, List<Module> modules) {
            if (modules.stream().map(Module::getName).anyMatch(this.protoStreamPredicate)) {
                return (Marshaller)PROTOSTREAM.apply(moduleLoader, modules);
            }
            return (Marshaller)JBOSS.apply(moduleLoader, modules);
        }
    }
    ,
    JBOSS{

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, List<Module> modules) {
            return (Marshaller)MarshallerFactory.JBOSS.apply((Object)moduleLoader, modules);
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public Marshaller apply(ModuleLoader moduleLoader, List<Module> modules) {
            return (Marshaller)MarshallerFactory.PROTOSTREAM.apply((Object)moduleLoader, modules);
        }
    };

}

