/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());

    private FactoryFinder() {
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
            }
            return cl;
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static <T> Object find(String factoryId, String fallbackClassName, Class<T> service) throws ClassNotFoundException {
        block23: {
            block21: {
                block22: {
                    classLoader = FactoryFinder.getContextClassLoader();
                    result = FactoryFinder.getFirstService(classLoader, factoryId, service);
                    if (result != null) {
                        return result;
                    }
                    result = FactoryFinder.getFirstService(FactoryFinder.getClassLoader(), factoryId, service);
                    if (result != null) {
                        return result;
                    }
                    inputStream = null;
                    configFile = null;
                    javah = System.getProperty("java.home");
                    configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                    f = new File(configFile);
                    if (!f.exists()) break block21;
                    props = new Properties();
                    inputStream = new FileInputStream(f);
                    props.load(inputStream);
                    factoryClassName = props.getProperty(factoryId);
                    var11_15 = FactoryFinder.newInstance(factoryClassName, classLoader);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
                return var11_15;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
            }
            break block23;
            catch (Exception ex) {
                try {
                    FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
                    ** if (inputStream == null) goto lbl-1000
                }
                catch (Throwable var13_17) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                        }
                    }
                    throw var13_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
        try {
            systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
        }
        if (fallbackClassName == null) {
            throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static <T> T getFirstService(ClassLoader cl, String factoryId, Class<T> service) {
        if (System.getSecurityManager() == null) {
            try {
                Iterator<T> iterator = ServiceLoader.load(service, cl).iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            return null;
        }
        return (T)AccessController.doPrivileged(() -> {
            try {
                Iterator iterator = ServiceLoader.load(service, cl).iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            return null;
        });
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader result = FactoryFinder.class.getClassLoader();
            if (result == null) {
                result = ClassLoader.getSystemClassLoader();
            }
            return result;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader result = FactoryFinder.class.getClassLoader();
            if (result == null) {
                result = ClassLoader.getSystemClassLoader();
            }
            return result;
        });
    }
}

