/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.importCalendar;

import com.silverpeas.importCalendar.SilverEvent;
import com.silverpeas.importCalendar.SilverEventsList;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class JournalHeadersListFactory {
    SimpleDateFormat _dateFormatter;
    SimpleDateFormat _timeFormatter;
    String _sessionId;
    int nbErrors = 0;

    public JournalHeadersListFactory(String sessionId) {
        this._sessionId = sessionId;
        this._dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
        this._timeFormatter = new SimpleDateFormat("HH:mm");
    }

    public List buildJournalHeadersList(SilverEventsList myEvents) {
        ArrayList<JournalHeader> headers = new ArrayList<JournalHeader>();
        for (int i = 1; i <= myEvents.getItemsListCount(); ++i) {
            headers.add(this.createJournalHeader(myEvents.getSilverEvent(i)));
        }
        return headers;
    }

    public JournalHeader createJournalHeader(SilverEvent event) {
        JournalHeader journal = null;
        try {
            journal = new JournalHeader(event.getSubject(), this._sessionId);
            journal.setDescription(event.getBody());
            journal.getPriority().setValue(event.getImportance());
            journal.getClassification().setString(event.getSensitivity());
            journal.setStartDay(this._dateFormatter.format(event.getStart()));
            journal.setEndDay(this._dateFormatter.format(event.getEnd()));
            if (event.getAllDayEvent()) {
                journal.setStartHour(null);
                journal.setEndHour(null);
                Calendar cal = Calendar.getInstance();
                cal.setTime(event.getEnd());
                cal.add(6, -1);
                journal.setEndDay(this._dateFormatter.format(cal.getTime()));
            } else {
                journal.setStartHour(this._timeFormatter.format(event.getStart()));
                journal.setEndHour(this._timeFormatter.format(event.getEnd()));
            }
            journal.setExternalId(event.getEntryId());
        }
        catch (Exception e) {
            e.printStackTrace();
            ++this.nbErrors;
        }
        return journal;
    }
}

