/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Stream;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.workflow.api.UserManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.api.user.UserInfo;
import org.silverpeas.core.workflow.api.user.UserSettings;
import org.silverpeas.core.workflow.engine.exception.UnknownUserException;
import org.silverpeas.core.workflow.engine.user.UserImpl;
import org.silverpeas.core.workflow.engine.user.UserSettingsService;

@Service
public class UserManagerImpl
implements UserManager {
    @Override
    public User getUser(String userId) throws WorkflowException {
        return new UserImpl(this.getUserDetail(userId));
    }

    @Override
    public User[] getUsers(String[] userIds) throws WorkflowException {
        User[] users = new User[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            users[i] = this.getUser(userIds[i]);
        }
        return users;
    }

    @Override
    public User[] getUsersInRole(String roleName, String modelId) {
        boolean includeRemovedUsers = !SilverpeasRole.SUPERVISOR.getName().equals(roleName) && UserManagerImpl.existsAtLeastOneValidReplacementAtNow(roleName, modelId);
        return (User[])Stream.of(OrganizationControllerProvider.getOrganisationController().getUsersIdsByRoleNames(modelId, List.of(roleName), includeRemovedUsers)).map(UserDetail::getById).map(UserImpl::new).toArray(User[]::new);
    }

    @Override
    public User[] getUsersInGroup(String groupId, String modelId) {
        UserDetailsSearchCriteria criteria = new UserDetailsSearchCriteria().onGroupIds(new String[]{groupId});
        if (UserManagerImpl.existsAtLeastOneValidReplacementAtNow(modelId)) {
            criteria.includeRemovedUsers();
        } else {
            criteria.onUserStatesToExclude(new UserState[]{UserState.REMOVED});
        }
        return (User[])OrganizationControllerProvider.getOrganisationController().searchUsers(criteria).stream().map(UserDetail.class::cast).map(UserImpl::new).toArray(User[]::new);
    }

    private UserDetail getUserDetail(String userId) throws WorkflowException {
        UserDetail userDetail = UserDetail.getById((String)userId);
        if (userDetail == null) {
            throw new UnknownUserException("UserManagerImpl.getUserDetail", userId);
        }
        return userDetail;
    }

    @Override
    public User getRelatedUser(User user, String relation, String peasId) throws WorkflowException {
        UserSettings settings = UserSettingsService.get().get(user.getUserId(), peasId);
        if (settings == null) {
            throw new WorkflowException("UserManagerImpl.getRelatedUser", "workflowEngine.EXP_NO_USER_SETTING", "user id : " + user.getUserId());
        }
        UserInfo info = settings.getUserInfo(relation);
        if (info == null) {
            throw new WorkflowException("UserManagerImpl.getRelatedUser", "workflowEngine.EXP_USERINFO_NOT_FOUND", "user id : " + user.getUserId() + ", info name : " + relation);
        }
        return this.getUser(info.getValue());
    }

    private static boolean existsAtLeastOneValidReplacementAtNow(String roleName, String modelId) {
        return Replacement.getAll(modelId).stream().filterCurrentAt(LocalDate.now()).filterOnAtLeastOneRole(roleName).findFirst().isPresent();
    }

    private static boolean existsAtLeastOneValidReplacementAtNow(String modelId) {
        return Replacement.getAll(modelId).stream().filterCurrentAt(LocalDate.now()).findFirst().isPresent();
    }
}

