/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.util.Arrays;
import java.util.List;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.kernel.logging.SilverLogger;

public final class UserImpl
implements User {
    private UserDetail userDetail = null;
    private UserFull userFull = null;
    private List<String> groupIds = null;

    public UserImpl(UserDetail userDetail) {
        this.userDetail = userDetail;
    }

    @Override
    public String getUserId() {
        return this.userDetail.getId();
    }

    @Override
    public String getFullName() {
        return this.userDetail.getDisplayedName();
    }

    @Override
    public String getInfo(String infoName) {
        if (this.userFull == null) {
            try {
                this.userFull = AdministrationServiceProvider.getAdminService().getUserFull(this.getUserId());
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
                return "";
            }
            if (this.userFull == null) {
                return "";
            }
        }
        return this.userFull.getValue(infoName);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.getUserId() != null ? this.getUserId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object user) {
        if (user == null || !(user instanceof UserImpl)) {
            return false;
        }
        return this.getUserId().equals(((UserImpl)user).getUserId());
    }

    @Override
    public List<String> getGroupIds() {
        if (this.groupIds == null) {
            this.groupIds = Arrays.asList(OrganizationControllerProvider.getOrganisationController().getAllGroupIdsOfUser(this.getUserId()));
        }
        return this.groupIds;
    }
}

