/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.DataRecordUtil;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.Input;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Parameter;
import org.silverpeas.core.workflow.engine.model.ItemImpl;
import org.silverpeas.core.workflow.engine.model.ItemRef;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;
import org.silverpeas.kernel.annotation.NonNull;

@XmlRootElement(name="form")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FormImpl
implements Form,
Serializable {
    @XmlAttribute
    @XmlID
    private String name;
    @XmlAttribute
    private String role;
    @XmlAttribute
    private String htmlFileName;
    @XmlElement(name="title", type=SpecificLabel.class)
    private List<ContextualDesignation> titles;
    @XmlElement(name="input", type=ItemRef.class)
    private List<Input> inputList;

    public FormImpl() {
        this.reset();
    }

    private void reset() {
        this.titles = new ArrayList<ContextualDesignation>();
        this.inputList = new Vector<Input>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public String getHTMLFileName() {
        return this.htmlFileName;
    }

    @Override
    public void setHTMLFileName(String htmlFileName) {
        this.htmlFileName = htmlFileName;
    }

    @Override
    public Input[] getInputs() {
        if (this.inputList == null) {
            return new Input[0];
        }
        return this.inputList.toArray(new Input[0]);
    }

    @Override
    public Input getInput(int idx) {
        return this.inputList.get(idx);
    }

    @Override
    public Input getInput(Input reference) {
        int idx = this.inputList.indexOf(reference);
        if (idx >= 0) {
            return this.inputList.get(idx);
        }
        return null;
    }

    @Override
    public void addInput(Input input) {
        this.inputList.add(input);
    }

    @Override
    public Iterator<Input> iterateInput() {
        return this.inputList.iterator();
    }

    @Override
    public Input createInput() {
        return new ItemRef();
    }

    @Override
    public void removeInput(int idx) {
        this.inputList.remove(idx);
    }

    @Override
    public ContextualDesignations getTitles() {
        return new SpecificLabelListHelper(this.titles);
    }

    @Override
    public String getTitle(String role, String language) {
        return this.getTitles().getLabel(role, language);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public RecordTemplate toRecordTemplate(String role, String lang) throws WorkflowException {
        return this.toRecordTemplate(role, lang, false);
    }

    @Override
    public DataRecord getDefaultRecord(String role, String lang, DataRecord data) throws WorkflowException {
        try {
            DataRecord defaultRecord = this.toRecordTemplate(role, lang).getEmptyRecord();
            if (this.inputList == null) {
                return defaultRecord;
            }
            int count = 0;
            for (Input input : this.inputList) {
                Field field;
                Object fieldName;
                Item item = input.getItem();
                if (item == null) {
                    fieldName = "label#" + count;
                    ++count;
                } else {
                    fieldName = item.getName();
                }
                String value = input.getValue();
                if (data != null) {
                    value = DataRecordUtil.applySubstitution((String)value, (DataRecord)data, (String)lang);
                }
                if ((field = defaultRecord.getField((String)fieldName)) == null) continue;
                field.setStringValue(value);
            }
            return defaultRecord;
        }
        catch (FormException e) {
            throw new WorkflowException(this.getClass().getName(), "Can't get default record", (Exception)((Object)e));
        }
    }

    @Override
    public RecordTemplate toRecordTemplate(String role, String lang, boolean readOnly) throws WorkflowException {
        GenericRecordTemplate rt = new GenericRecordTemplate();
        if (this.inputList == null) {
            return rt;
        }
        try {
            int count = 0;
            for (Input input : this.inputList) {
                ItemImpl item = (ItemImpl)input.getItem();
                if (item == null) {
                    item = new ItemImpl();
                    item.setName("label#" + count);
                    item.setType("text");
                    ++count;
                }
                GenericFieldTemplate ft = this.createNewFieldTemplate(input, item, readOnly);
                FormImpl.setRoleInFieldTemplate(ft, input, item, role, lang);
                FormImpl.addParametersInFieldTemplate(ft, item);
                rt.addFieldTemplate((FieldTemplate)ft);
            }
            return rt;
        }
        catch (FormException fe) {
            throw new WorkflowException("FormImpl.toRecordTemplate()", "workflowEngine.EX_ERR_BUILD_FIELD_TEMPLATE", (Exception)((Object)fe));
        }
    }

    private static void addParametersInFieldTemplate(GenericFieldTemplate ft, ItemImpl item) {
        Iterator<Parameter> parameters = item.iterateParameter();
        while (parameters.hasNext()) {
            Parameter param = parameters.next();
            if (param == null) continue;
            ft.addParameter(param.getName(), param.getValue());
        }
    }

    private static void setRoleInFieldTemplate(GenericFieldTemplate ft, Input input, ItemImpl item, String role, String lang) {
        if (role != null && lang != null) {
            String label = input.getLabel(role, lang);
            if (label == null || label.isEmpty()) {
                ft.addLabel(item.getLabel(role, lang), lang);
            } else {
                ft.addLabel(label, lang);
            }
        }
    }

    @NonNull
    private GenericFieldTemplate createNewFieldTemplate(Input input, ItemImpl item, boolean readOnly) throws FormException {
        GenericFieldTemplate ft = new GenericFieldTemplate(item.getName(), item.getType());
        if (readOnly) {
            ft.setReadOnly(true);
        } else {
            ft.setReadOnly(input.isReadonly());
        }
        ft.setMandatory(input.isMandatory());
        ft.setTemplateName("form:" + this.name);
        if (input.getDisplayerName() != null && !input.getDisplayerName().isEmpty()) {
            ft.setDisplayerName(input.getDisplayerName());
        }
        return ft;
    }
}

