/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.instance;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;

@Entity
@Table(name="sb_workflow_historystep")
public class HistoryStepImpl
extends BasicJpaEntity<HistoryStepImpl, UniqueIntegerIdentifier>
implements UpdatableHistoryStep,
Comparable<HistoryStep> {
    private static final String WORKFLOW_ENGINE_EXP_UNKNOWN_FORM = "workflowEngine.EXP_UNKNOWN_FORM";
    private static final String FORM = "form=";
    @ManyToOne
    @JoinColumn(name="instanceid", nullable=false)
    private ProcessInstanceImpl processInstance = null;
    @Column
    private String userId = null;
    @Column
    private String userRoleName = null;
    @Column
    private String action = null;
    @Column
    private Date actionDate = null;
    @Column
    private String resolvedState = null;
    @Column(name="tostate")
    private String resultingState = null;
    @Column
    private String substituteId = null;
    @Column
    private int actionStatus = ActionStatus.TO_BE_PROCESSED.getCode();

    public HistoryStepImpl() {
        this.setTodayAsActionDate();
    }

    public HistoryStepImpl(int id) {
        this.setTodayAsActionDate();
        this.setId(String.valueOf(id));
    }

    @Override
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Override
    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = (ProcessInstanceImpl)processInstance;
    }

    @Override
    public User getUser() throws WorkflowException {
        return this.getUserId() != null ? WorkflowHub.getUserManager().getUser(this.getUserId()) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getUserRoleName() {
        return this.userRoleName;
    }

    @Override
    public void setUserRoleName(String userRoleName) {
        this.userRoleName = userRoleName;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public Date getActionDate() {
        return this.actionDate;
    }

    @Override
    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    private void setTodayAsActionDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        this.actionDate = calendar.getTime();
    }

    @Override
    public String getResolvedState() {
        return this.resolvedState;
    }

    @Override
    public void setResolvedState(String state) {
        this.resolvedState = state;
    }

    @Override
    public String getResultingState() {
        return this.resultingState;
    }

    @Override
    public void setResultingState(String state) {
        this.resultingState = state;
    }

    @Override
    public ActionStatus getActionStatus() {
        return ActionStatus.from(this.actionStatus);
    }

    @Override
    public void setActionStatus(ActionStatus actionStatus) {
        this.actionStatus = actionStatus.getCode();
    }

    @Override
    public String getSubstituteId() {
        return this.substituteId;
    }

    @Override
    public void setSubstituteId(String substituteId) {
        this.substituteId = substituteId;
    }

    @Override
    public DataRecord getActionRecord() throws WorkflowException {
        ProcessModel model = this.processInstance.getProcessModel();
        Action actionObj = model.getAction(this.action);
        if (actionObj == null) {
            return null;
        }
        Form form = actionObj.getForm();
        if (form == null) {
            return null;
        }
        String formId = this.getId();
        try {
            RecordSet formSet = model.getFormRecordSet(form.getName());
            return formSet.getRecord(formId);
        }
        catch (FormException e) {
            throw new WorkflowException("HistoryStepImpl", WORKFLOW_ENGINE_EXP_UNKNOWN_FORM, FORM + form.getName() + "(" + formId + ")", (Exception)((Object)e));
        }
    }

    @Override
    public void setActionRecord(DataRecord data) throws WorkflowException {
        ProcessModel model = this.processInstance.getProcessModel();
        Action actionObj = model.getAction(this.action);
        if (actionObj == null) {
            return;
        }
        Form form = actionObj.getForm();
        if (form == null) {
            return;
        }
        String formId = this.getId();
        try {
            DataRecord previousRecord;
            RecordSet formSet = model.getFormRecordSet(form.getName());
            if (this.actionStatus == 3 && (previousRecord = formSet.getRecord(formId)) != null) {
                formSet.delete(formId);
            }
            data.setId(formId);
            formSet.save(data);
        }
        catch (FormException e) {
            throw new WorkflowException("ProcessInstanceImpl", WORKFLOW_ENGINE_EXP_UNKNOWN_FORM, FORM + form.getName() + "(" + formId + ")", (Exception)((Object)e));
        }
    }

    @Override
    public void deleteActionRecord() throws WorkflowException {
        ProcessModel model = this.processInstance.getProcessModel();
        if ("#reAssign#".equals(this.action)) {
            return;
        }
        Action actionObj = model.getAction(this.action);
        if (actionObj == null) {
            return;
        }
        Form form = actionObj.getForm();
        if (form == null) {
            return;
        }
        String formId = this.getId();
        try {
            RecordSet formSet = model.getFormRecordSet(form.getName());
            formSet.delete(formId);
        }
        catch (FormException e) {
            throw new WorkflowException("ProcessInstanceImpl", WORKFLOW_ENGINE_EXP_UNKNOWN_FORM, FORM + form.getName() + "(" + formId + ")", (Exception)((Object)e));
        }
    }

    @Override
    public int compareTo(HistoryStep anotherStep) {
        if (anotherStep == null) {
            return 0;
        }
        int stepId = Integer.parseInt(this.getId());
        int anotherStepId = Integer.parseInt(anotherStep.getId());
        return stepId - anotherStepId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryStepImpl)) {
            return false;
        }
        HistoryStepImpl that = (HistoryStepImpl)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }
}

