/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.portletcontainer.appengine.StringServletOutputStream;
import com.sun.portal.portletcontainer.common.PortletContainerResourceRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.CacheControlImpl;
import com.sun.portal.portletcontainer.portlet.impl.MimeResponseImpl;
import java.io.StringWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceResponseImpl
extends MimeResponseImpl
implements ResourceResponse {
    private PortletContainerResourceRequest pcResourceRequest;
    private PortletContainerResourceResponse pcResourceResponse;
    private ResourceRequest resourceRequest;

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerResourceRequest pcResourceRequest, PortletContainerResourceResponse pcResourceResponse, ResourceRequest resourceRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, StringWriter stringWriter, StringServletOutputStream outputStream) {
        super.init(request, response, pcResourceRequest, pcResourceResponse, (PortletRequest)resourceRequest, portletAppDescriptor, portletDescriptor, stringWriter, outputStream);
        this.pcResourceRequest = pcResourceRequest;
        this.pcResourceResponse = pcResourceResponse;
        this.resourceRequest = resourceRequest;
    }

    protected void clear() {
        super.clear();
        this.pcResourceRequest = null;
        this.pcResourceResponse = null;
        this.resourceRequest = null;
    }

    public void setLocale(Locale loc) {
        this.getHttpServletResponse().setLocale(loc);
    }

    public void setCharacterEncoding(String charset) {
        this.getHttpServletResponse().setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.getHttpServletResponse().setContentLength(len);
    }

    public void setContentType(String type) {
        this.contentType = type;
        this.getHttpServletResponse().setContentType(type);
        this.pcResourceResponse.setContentType(type);
    }

    protected void setCacheability(ResourceURL resourceURL) {
        String cacheLevel = this.pcResourceRequest.getCacheLevel();
        if (cacheLevel == null || cacheLevel.trim().length() == 0) {
            resourceURL.setCacheability("cacheLevelPage");
        } else {
            resourceURL.setCacheability(cacheLevel);
        }
    }

    public PortletURL createActionURL() throws IllegalStateException {
        String cacheLevel = this.pcResourceRequest.getCacheLevel();
        if (cacheLevel != null && !cacheLevel.equals("cacheLevelPage")) {
            throw new IllegalStateException("The cacheability level of the resource URL triggering this serveResource call is not PAGE and thus does not allow for creating action URLs.");
        }
        return super.createActionURL();
    }

    public PortletURL createRenderURL() throws IllegalStateException {
        String cacheLevel = this.pcResourceRequest.getCacheLevel();
        if (cacheLevel != null && !cacheLevel.equals("cacheLevelPage")) {
            throw new IllegalStateException("The cacheability level of the resource URL triggering this serveResource call is not PAGE and thus does not allow for creating render URLs.");
        }
        return super.createRenderURL();
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        if (key.equals("portlet.expiration-cache")) {
            int cacheVal = this.pcResourceResponse.getCacheControl().getExpirationTime();
            if (cacheVal != -999) {
                try {
                    cacheVal = Integer.parseInt(value);
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
                this.pcResourceResponse.getCacheControl().setExpirationTime(cacheVal);
            }
        } else if (key.equals("portlet.cache-scope")) {
            if (this.pcResourceResponse.getCacheControl().getExpirationTime() != -999) {
                this.pcResourceResponse.getCacheControl().setPublicScope("portlet.public-scope".equals(value));
            }
        } else if (key.equals("portlet.public-scope")) {
            this.pcResourceResponse.getCacheControl().setPublicScope("true".equals(value));
        } else if (key.equals("portlet.private-scope")) {
            this.pcResourceResponse.getCacheControl().setPublicScope("false".equals(value));
        } else if (key.equals("portlet.ETag")) {
            this.pcResourceResponse.getCacheControl().setETag(value);
        } else if (key.equals("portlet.use-cached-content")) {
            boolean useCachedContent = Boolean.parseBoolean(value);
            this.pcResourceResponse.getCacheControl().setUseCachedContent(useCachedContent);
        } else {
            super.setProperty(key, value);
        }
    }

    public CacheControl getCacheControl() {
        return new CacheControlImpl(this.pcResourceResponse.getCacheControl());
    }
}

