/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.portletcontainer.common.descriptor.InitParamDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletConfigImpl
implements PortletConfig {
    private String portletName;
    private PortletContext portletContext;
    private PortletDescriptor portletDescriptor;
    private PortletAppDescriptor portletAppDescriptor;
    private Map paramsMap = new HashMap();

    public PortletConfigImpl(PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, String portletName, PortletContext portletContext) {
        this.portletName = portletName;
        this.portletContext = portletContext;
        this.portletDescriptor = portletDescriptor;
        this.portletAppDescriptor = portletAppDescriptor;
        this.initParamsMap();
    }

    private void initParamsMap() {
        if (this.portletDescriptor != null && this.portletDescriptor.getInitParamDescriptors() != null) {
            for (InitParamDescriptor ipd : this.portletDescriptor.getInitParamDescriptors()) {
                this.paramsMap.put(ipd.getParamName(), ipd.getParamValue());
            }
        }
    }

    public String getInitParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this.paramsMap.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.paramsMap.keySet());
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public ResourceBundle getResourceBundle(Locale locale) throws MissingResourceException {
        ResourceBundle rb = null;
        if (this.portletDescriptor == null) {
            throw new MissingResourceException("PortletConfigImpl.getResourceBundle: missing portlet descriptor", null, null);
        }
        String rbName = this.portletDescriptor.getResourceBundle();
        PortletInfoDescriptor pid = this.portletDescriptor.getPortletInfoDescriptor();
        Object[] values = new Object[]{"", "", ""};
        boolean[] valuesDefinedInline = new boolean[]{false, false, false};
        if (pid != null) {
            if (pid.getTitle() != null) {
                values[0] = pid.getTitle();
                valuesDefinedInline[0] = true;
            }
            if (pid.getShortTitle() != null) {
                values[1] = pid.getShortTitle();
                valuesDefinedInline[1] = true;
            }
            if (pid.getKeywords() != null) {
                List keywords = pid.getKeywords();
                String[] strArray = new String[keywords.size()];
                values[2] = keywords.toArray(strArray);
                valuesDefinedInline[2] = true;
            }
        }
        try {
            if (rbName != null) {
                rb = ResourceBundle.getBundle(rbName, locale, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (MissingResourceException me) {
            // empty catch block
        }
        rb = new PortletResourceBundle(rb, rbName, values, valuesDefinedInline);
        return rb;
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        List<String> publicRenderParameters = this.portletDescriptor.getSupportedPublicRenderParameterIdentifiers();
        if (publicRenderParameters != null) {
            return Collections.enumeration(publicRenderParameters);
        }
        List emptyList = Collections.emptyList();
        return Collections.enumeration(emptyList);
    }

    public String getDefaultNamespace() {
        return this.portletAppDescriptor.getDefaultNamespace();
    }

    public Enumeration<QName> getPublishingEventQNames() {
        List<QName> supportedPublishingEvents = this.portletDescriptor.getSupportedPublishingEvents();
        if (supportedPublishingEvents != null) {
            return Collections.enumeration(supportedPublishingEvents);
        }
        List emptyList = Collections.emptyList();
        return Collections.enumeration(emptyList);
    }

    public Enumeration<QName> getProcessingEventQNames() {
        List<QName> supportedProcessingEvents = this.portletDescriptor.getSupportedProcessingEvents();
        if (supportedProcessingEvents != null) {
            return Collections.enumeration(supportedProcessingEvents);
        }
        List emptyList = Collections.emptyList();
        return Collections.enumeration(emptyList);
    }

    public Enumeration<Locale> getSupportedLocales() {
        List<String> supportedLocaleStrings = this.portletDescriptor.getSupportedLocales();
        if (supportedLocaleStrings != null) {
            ArrayList<Locale> supportedLocales = new ArrayList<Locale>(supportedLocaleStrings.size());
            for (String s : supportedLocaleStrings) {
                supportedLocales.add(new Locale(s));
            }
            return Collections.enumeration(supportedLocales);
        }
        List emptyList = Collections.emptyList();
        return Collections.enumeration(emptyList);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this.portletAppDescriptor.getContainerRuntimeOptions(this.portletDescriptor.getPortletID());
    }
}

