/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.StringServletOutputStream;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletResponseImpl;
import com.sun.portal.portletcontainer.portlet.impl.ResourceURLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;

public abstract class MimeResponseImpl
extends PortletResponseImpl
implements MimeResponse {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private PortletContainerRequest pcRequest;
    private PortletContainerResponse pcResponse;
    private PortletRequest portletRequest;
    private PrintWriter printWriter;
    private StringWriter stringWriter;
    private StringServletOutputStream outputStream;
    protected String contentType;
    private boolean gotWriter;
    private boolean gotOutputStream;
    private boolean committed;
    private int bufSize;
    private static Logger logger = ContainerLogger.getLogger(MimeResponseImpl.class, (String)"PAELogMessages");

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse, PortletRequest portletRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, StringWriter stringWriter, StringServletOutputStream outputStream) {
        super.init(request, response, pcRequest, pcResponse, portletRequest, portletAppDescriptor, portletDescriptor);
        this.request = request;
        this.response = response;
        this.pcRequest = pcRequest;
        this.pcResponse = pcResponse;
        this.portletRequest = portletRequest;
        this.printWriter = new PrintWriter(stringWriter);
        this.stringWriter = stringWriter;
        this.outputStream = outputStream;
        this.gotWriter = false;
        this.gotOutputStream = false;
        this.committed = false;
        this.bufSize = 1024;
    }

    protected void clear() {
        super.clear();
        this.request = null;
        this.response = null;
        this.pcRequest = null;
        this.pcResponse = null;
        this.portletRequest = null;
        this.printWriter = null;
        this.stringWriter = null;
        this.outputStream = null;
        this.gotWriter = false;
        this.gotOutputStream = false;
        this.committed = false;
        this.bufSize = 0;
        this.contentType = null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        if (!this.gotWriter || !this.gotOutputStream) {
            if (type.indexOf(";") != -1) {
                type = type.substring(0, type.indexOf(";"));
            }
            boolean found = false;
            Enumeration e = this.portletRequest.getResponseContentTypes();
            while (e.hasMoreElements() && !found) {
                String next = (String)e.nextElement();
                if (type.equalsIgnoreCase(next)) {
                    found = true;
                }
                if (!next.equals("*/*")) continue;
                found = true;
            }
            if (found) {
                this.contentType = type;
                this.response.setContentType(type);
            } else {
                throw new IllegalArgumentException("Unsupported response content type: " + type);
            }
        }
    }

    public void addProperty(String key, String value) {
        this.checkNullProperty(key);
        if (!this.isCommitted()) {
            super.addProperty(key, value);
        }
    }

    public void addProperty(String key, Element element) {
        this.checkNullProperty(key);
        if (!this.isCommitted()) {
            super.addProperty(key, element);
        }
    }

    public void setProperty(String key, String value) {
        this.checkNullProperty(key);
        if (!this.isCommitted()) {
            super.setProperty(key, value);
        }
    }

    public void addProperty(Cookie cookie) {
        this.checkNullCookie(cookie);
        if (!this.isCommitted()) {
            super.addProperty(cookie);
        }
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.gotOutputStream) {
            throw new IllegalStateException("MimeResponseImpl.getWriter: illegal getting writer since getPortletOutputStream() has already been called");
        }
        if (!this.isContentTypeSet()) {
            this.setContentType(this.portletRequest.getResponseContentType());
        }
        this.gotWriter = true;
        return this.printWriter;
    }

    private boolean isContentTypeSet() {
        boolean set = true;
        if (this.getContentType() == null) {
            set = false;
        }
        return set;
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public void setBufferSize(int size) {
        if (this.stringWriter.getBuffer().length() > 0) {
            throw new IllegalStateException("This method cannot be called after content has been written");
        }
        this.bufSize = size;
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("MimeResponseImpl.resetBuffer: illegal resetting buffer: buffer has already commited.");
        }
        if (this.gotOutputStream) {
            this.outputStream.reset();
        }
        if (this.gotWriter) {
            this.stringWriter.getBuffer().setLength(0);
        }
    }

    public boolean isCommitted() {
        int size = 0;
        if (this.gotOutputStream) {
            size = this.outputStream.size();
        } else if (this.gotWriter) {
            size = this.stringWriter.getBuffer().length();
        }
        if (size > 1024) {
            this.committed = true;
        }
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.gotWriter) {
            throw new IllegalStateException("MimeResponseImpl.getOutputStream: illegal getting output stream: getWriter() has already been called");
        }
        if (!this.isContentTypeSet()) {
            this.setContentType(this.portletRequest.getResponseContentType());
        }
        this.gotOutputStream = true;
        return this.outputStream;
    }

    public ResourceURL createResourceURL() {
        ResourceURLImpl resourceURL = new ResourceURLImpl(this.portletRequest, this.pcRequest, this.getPortletAppDescriptor(), this.getPortletDescriptor(), "RESOURCE");
        this.setCacheability(resourceURL);
        this.callURLGenerationListeners("RESOURCE", resourceURL);
        return resourceURL;
    }

    public abstract CacheControl getCacheControl();

    protected abstract void setCacheability(ResourceURL var1);
}

