/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;

public class SecurityRoleRefDescriptor {
    private String roleName;
    private String roleLink;
    private List descriptions = new ArrayList();
    private Map descriptionMap = new HashMap();

    public void load(Element element, String namespaceURI) {
        this.roleName = PortletXMLDocumentHelper.getChildTextTrim(element, "role-name");
        this.roleLink = PortletXMLDocumentHelper.getChildTextTrim(element, "role-link");
        List<Element> descriptionElements = PortletXMLDocumentHelper.getChildElements(element, "description");
        int numDescriptions = descriptionElements.size();
        for (int i = 0; i < numDescriptions; ++i) {
            String lang;
            Element descriptionElement = descriptionElements.get(i);
            String description = PortletXMLDocumentHelper.getTextTrim(descriptionElement);
            this.descriptions.add(description);
            Map<String, String> descAttributes = PortletXMLDocumentHelper.getAttributeTable(descriptionElement);
            Iterator<Map.Entry<String, String>> dait = descAttributes.entrySet().iterator();
            if (dait.hasNext()) {
                while (dait.hasNext()) {
                    Map.Entry<String, String> entry = dait.next();
                    lang = entry.getKey();
                    if (!lang.equals("xml:lang")) continue;
                    this.descriptionMap.put(entry.getValue(), description);
                }
                continue;
            }
            lang = Locale.getDefault().toString().replace('_', '-');
            this.descriptionMap.put(lang, description);
        }
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRoleLink() {
        return this.roleLink;
    }

    public String getDescription() {
        String description = null;
        if (!this.descriptions.isEmpty()) {
            description = (String)this.descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this.descriptions;
    }

    public Map getDescriptionMap() {
        return this.descriptionMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityRoleDescriptor ");
        sb.append(" role name [");
        if (this.roleName != null) {
            sb.append(this.roleName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" role link [");
        if (this.roleLink != null) {
            sb.append(this.roleLink);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" description [");
        if (!this.descriptions.isEmpty()) {
            sb.append((String)this.descriptions.get(0));
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        return sb.toString();
    }
}

