/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.wbe.WbeFileLock;
import org.silverpeas.kernel.util.StringUtil;

public abstract class WbeFile
implements Securable {
    private OffsetDateTime lastEditionDate;
    private WbeFileLock lock;

    public OffsetDateTime getLastEditionDate() {
        return this.lastEditionDate;
    }

    public abstract Optional<ResourceReference> linkedToResource();

    public abstract String silverpeasId();

    public String id() {
        return this.silverpeasId();
    }

    public abstract User owner();

    public abstract String name();

    public String ext() {
        return FilenameUtils.getExtension((String)this.name());
    }

    public abstract String mimeType();

    public abstract long size();

    public abstract OffsetDateTime lastModificationDate();

    public String version() {
        return StringUtil.asBase64((byte[])(this.name() + "#" + this.lastModificationDate().withOffsetSameInstant(ZoneOffset.UTC)).getBytes(Charsets.UTF_8));
    }

    public abstract void updateFrom(InputStream var1) throws IOException;

    public abstract void loadInto(OutputStream var1) throws IOException;

    public WbeFileLock lock() {
        if (this.lock == null) {
            this.lock = new WbeFileLock();
        }
        return this.lock;
    }

    public void setLastEditionDateAtNow() {
        this.lastEditionDate = OffsetDateTime.now();
    }

    public String toString() {
        return new StringJoiner(", ", WbeFile.class.getSimpleName() + "[", "]").add("silverpeasId=" + this.silverpeasId()).add("id=" + this.id()).add("name=" + this.name()).add("lastModificationDate=" + this.lastModificationDate()).add("mimeType=" + this.mimeType()).add("size=" + this.size()).add("version=" + this.version()).add("lock=" + this.lock()).add("lastEditionDate=" + this.getLastEditionDate()).toString();
    }
}

