/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class Either<T, U> {
    private final U right;
    private final T left;

    @Nonnull
    public static <T, U> Either<T, U> left(@Nonnull T left) {
        Objects.requireNonNull(left);
        return new Either<T, Object>(left, null);
    }

    @Nonnull
    public static <T, U> Either<T, U> right(@Nonnull U right) {
        Objects.requireNonNull(right);
        return new Either<Object, U>(null, right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    @Nonnull
    public T getLeft() {
        if (this.left == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.left;
    }

    @Nonnull
    public U getRight() {
        if (this.right == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.right;
    }

    public void ifLeftOrRight(Consumer<? super T> leftConsumer, Consumer<? super U> rightConsumer) {
        if (this.isLeft()) {
            leftConsumer.accept(this.left);
        } else {
            rightConsumer.accept(this.right);
        }
    }

    public <R> R apply(@Nonnull Function<? super T, ? extends R> leftFunction, @Nonnull Function<? super U, ? extends R> rightFunction) {
        if (this.isLeft()) {
            return leftFunction.apply(this.left);
        }
        return rightFunction.apply(this.right);
    }

    private Either(T left, U right) {
        this.left = left;
        this.right = right;
    }
}

