/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.util.StringUtil;

public class BeanCriteria {
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String WHERE = " WHERE ";
    private final StringBuilder filter = new StringBuilder();
    private String orderBy = "";
    private final List<Object> params = new ArrayList<Object>();

    private BeanCriteria() {
    }

    public static BeanCriteria emptyCriteria() {
        return new BeanCriteria();
    }

    public static BeanCriteria addCriterion(String propertyName, Object propertyValue) {
        return BeanCriteria.addCriterion(propertyName, OPERATOR.EQUALS, propertyValue);
    }

    public static BeanCriteria addCriterion(String propertyName, OPERATOR operator, Object propertyValue) {
        if (operator == OPERATOR.IN && propertyValue instanceof Collection) {
            return BeanCriteria.addCriterion(propertyName, (Collection)propertyValue);
        }
        return BeanCriteria.emptyCriteria().and(propertyName, operator, propertyValue);
    }

    public static BeanCriteria addCriterion(String propertyName, Collection<?> propertyValues) {
        return BeanCriteria.emptyCriteria().and(propertyName, propertyValues);
    }

    public boolean isEmpty() {
        return this.filter.length() == 0;
    }

    public BeanCriteria and(String propertyName, Object propertyValue) {
        return this.and(propertyName, OPERATOR.EQUALS, propertyValue);
    }

    public BeanCriteria andWithFunction(String propertyName, Object propertyValue, String sqlFunction) {
        return this.and(propertyName, OPERATOR.EQUALS, propertyValue, sqlFunction);
    }

    public BeanCriteria and(String propertyName, OPERATOR operator, Object propertyValue) {
        if (operator == OPERATOR.IN && propertyValue instanceof Collection) {
            return this.and(propertyName, (Collection)propertyValue);
        }
        return this.and(propertyName, operator, propertyValue, null);
    }

    public BeanCriteria and(String propertyName, OPERATOR operator, Object propertyValue, String sqlFunction) {
        return this.computeCriterion(AND, propertyName, operator, propertyValue, sqlFunction);
    }

    public BeanCriteria and(String propertyName, Collection<?> propertyValues) {
        if (!propertyValues.isEmpty()) {
            StringBuilder clause = this.isEmpty() ? this.filter.append(WHERE) : this.filter.append(AND);
            this.setPropertyInPropertyValues(clause, propertyName, propertyValues);
        }
        return this;
    }

    public BeanCriteria or(String propertyName, Object propertyValue) {
        return this.or(propertyName, OPERATOR.EQUALS, propertyValue);
    }

    public BeanCriteria orWithFunction(String propertyName, Object propertyValue, String sqlFunction) {
        return this.or(propertyName, OPERATOR.EQUALS, propertyValue, sqlFunction);
    }

    public BeanCriteria or(String propertyName, OPERATOR operator, Object propertyValue) {
        return this.or(propertyName, operator, propertyValue, null);
    }

    public BeanCriteria or(String propertyName, OPERATOR operator, Object propertyValue, String sqlFunction) {
        return this.computeCriterion(OR, propertyName, operator, propertyValue, sqlFunction);
    }

    public BeanCriteria or(String propertyName, Set<?> propertyValues) {
        StringBuilder clause = this.isEmpty() ? this.filter.append(WHERE) : this.filter.append(OR);
        this.setPropertyInPropertyValues(clause, propertyName, propertyValues);
        return this;
    }

    public BeanCriteria andSubQuery(String propertyName, OPERATOR operator, String query, BeanCriteria queryCriteria) {
        StringBuilder clause = this.isEmpty() ? this.filter.append(WHERE) : this.filter.append(AND);
        clause.append(propertyName).append(operator.toString()).append("(SELECT ").append(query).append(" ").append(queryCriteria.toString()).append(")");
        this.params.addAll(queryCriteria.params);
        return this;
    }

    public BeanCriteria and(BeanCriteria criteria) {
        return this.append(criteria, AND);
    }

    public BeanCriteria or(BeanCriteria criteria) {
        return this.append(criteria, OR);
    }

    public void setDescOrderBy(String ... propertyNames) {
        this.orderBy = " ORDER BY " + String.join((CharSequence)" DESC, ", propertyNames) + " DESC";
    }

    public void setAscOrderBy(String ... propertyNames) {
        this.orderBy = " ORDER BY " + String.join((CharSequence)" ASC, ", propertyNames) + " ASC";
    }

    public String toString() {
        return this.filter + (StringUtil.isDefined((String)this.orderBy) ? this.orderBy : "");
    }

    @NonNull
    private BeanCriteria computeCriterion(String or, String propertyName, OPERATOR operator, Object propertyValue, String sqlFunction) {
        StringBuilder clause = this.isEmpty() ? this.filter.append(WHERE) : this.filter.append(or);
        Object funcApplied = StringUtil.isDefined((String)sqlFunction) ? sqlFunction + "(?)" : "?";
        clause.append(propertyName).append(operator.toString()).append((String)funcApplied);
        this.params.add(propertyValue);
        return this;
    }

    private BeanCriteria append(@NonNull BeanCriteria criteria, @NonNull String junctionOperator) {
        if (!criteria.isEmpty()) {
            StringBuilder clause = this.isEmpty() ? this.filter.append(WHERE).append("(") : this.filter.append(junctionOperator).append("(");
            clause.append(criteria.filter.substring(WHERE.length())).append(")");
            this.params.addAll(criteria.params);
        }
        return this;
    }

    private void setPropertyInPropertyValues(StringBuilder clause, String propertyName, Collection<?> propertyValues) {
        if (propertyValues.size() >= 1000) {
            clause.append("(");
            for (Object property : propertyValues) {
                clause.append(propertyName).append(" = ? ").append(OR);
                this.params.add(property);
            }
            clause.replace(clause.length() - OR.length(), clause.length(), ")");
        } else {
            clause.append(propertyName).append((Object)OPERATOR.IN).append(" (");
            for (Object property : propertyValues) {
                clause.append("?,");
                this.params.add(property);
            }
            clause.replace(clause.length() - 1, clause.length(), ")");
        }
    }

    CriteriaApplication withConnection(Connection connection) {
        return new CriteriaApplication(connection);
    }

    class CriteriaApplication {
        private final Connection connection;

        private CriteriaApplication(Connection connection) {
            this.connection = connection;
        }

        PreparedStatement applyTo(String query) throws SQLException {
            String finalQuery = query + BeanCriteria.this;
            PreparedStatement statement = this.connection.prepareStatement(finalQuery);
            for (int i = 0; i < BeanCriteria.this.params.size(); ++i) {
                Object paramValue = BeanCriteria.this.params.get(i);
                if (paramValue instanceof String) {
                    statement.setString(i + 1, (String)paramValue);
                    continue;
                }
                if (paramValue instanceof Integer) {
                    statement.setInt(i + 1, (Integer)paramValue);
                    continue;
                }
                if (paramValue instanceof Long) {
                    statement.setLong(i + 1, (Long)paramValue);
                    continue;
                }
                throw new SilverpeasRuntimeException("Unsupported type: " + paramValue.getClass().getName());
            }
            return statement;
        }
    }

    public static enum OPERATOR {
        EQUALS(" = "),
        NOT_EQUALS(" <> "),
        GREATER(" > "),
        GREATER_OR_EQUAL(" >= "),
        LIKE(" LIKE "),
        IN(" IN ");

        private final String op;

        private OPERATOR(String operator) {
            this.op = operator;
        }

        public String toString() {
            return this.op;
        }
    }
}

