/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;

@Service
@Singleton
public class DefaultServerEventContextManager
implements SilverpeasServerEventContextManager {
    final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    final Set<SilverpeasServerEventContext> contexts = new HashSet<SilverpeasServerEventContext>(2000);

    @PreDestroy
    protected void cleanContexts() {
        this.safeWrite(null, s -> {
            this.contexts.clear();
            return true;
        });
    }

    @Override
    public void register(SilverpeasServerEventContext context) {
        if (this.add(context)) {
            SseLogger.get().debug(() -> MessageFormat.format("Registering {0}, handling now {1} {1,choice, 1#server event context| 1<server event contexts}", context, this.getContextSize()));
        }
    }

    @Override
    public void unregister(SilverpeasServerEventContext context) {
        if (this.remove(context)) {
            SseLogger.get().debug(() -> MessageFormat.format("Unregistering {0}, handling now {1} {1,choice, 1#async context| 1<async contexts}", context, this.getContextSize()));
            context.close();
        }
    }

    @Override
    public List<SilverpeasServerEventContext> getContextSnapshot() {
        return this.safeRead(() -> new ArrayList<SilverpeasServerEventContext>(this.contexts));
    }

    private boolean add(SilverpeasServerEventContext context) {
        return this.safeWrite(context, this.contexts::add);
    }

    private boolean remove(SilverpeasServerEventContext context) {
        return this.safeWrite(context, this.contexts::remove);
    }

    private int getContextSize() {
        return this.safeRead(this.contexts::size);
    }

    private <R> R safeRead(Supplier<R> supplier) {
        this.lock.readLock().lock();
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R safeWrite(SilverpeasServerEventContext context, Function<SilverpeasServerEventContext, R> function) {
        this.lock.writeLock().lock();
        try {
            R r = function.apply(context);
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

