/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.NoSuchPropertyException;
import org.silverpeas.core.util.filter.FilterByType;

public class DefaultContributionModel<C extends Contribution>
implements ContributionModel {
    private final C contribution;

    protected DefaultContributionModel(C contribution) {
        this.contribution = contribution;
    }

    public FilterByType filterByType(String property, Object ... parameters) {
        return new FilterByType(this.getProperty(property, parameters));
    }

    @Override
    public <T> T getProperty(String property, Object ... parameters) {
        return this.getByReflection(property, parameters);
    }

    protected <T> T getByReflection(String property, Object ... parameters) {
        try {
            return this.invokeAccessor(property, parameters);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                return this.invoke(property, parameters);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                return this.noSuchPropertyException(property, parameters);
            }
        }
    }

    private <T> T invokeAccessor(String property, Object ... parameters) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (property.startsWith("is") || property.startsWith("get") || property.startsWith("has")) {
            return this.invoke(property, parameters);
        }
        String propName = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        try {
            return this.invoke(propName, parameters);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            propName = "is" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
            return this.invoke(propName, parameters);
        }
    }

    private <T> T invoke(String property, Object ... parameters) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class[] paramTypes = Stream.of(parameters).map(Object::getClass).collect(Collectors.toList()).toArray(new Class[parameters.length]);
        Method method = this.contribution.getClass().getDeclaredMethod(property, paramTypes);
        return (T)method.invoke(this.contribution, parameters);
    }

    private <T> T noSuchPropertyException(String property, Object[] parameters) {
        Object paramsMsg = "";
        if (parameters.length > 0) {
            paramsMsg = " with as parameters " + Arrays.toString(parameters);
        }
        throw new NoSuchPropertyException("The property " + property + " isn't supported by the contribution " + this.contribution.getClass().getSimpleName() + (String)paramsMsg);
    }

    protected C getContribution() {
        return this.contribution;
    }
}

