/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasPersonalComponentInstance;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEvents;
import org.silverpeas.core.calendar.CalendarReference;
import org.silverpeas.core.calendar.CalendarTimeWindow;
import org.silverpeas.core.calendar.ComponentInstanceCalendars;
import org.silverpeas.core.calendar.ICalendarEventSynchronization;
import org.silverpeas.core.calendar.ICalendarImportResult;
import org.silverpeas.core.calendar.notification.CalendarLifeCycleEventNotifier;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.calendar.repository.CalendarRepository;
import org.silverpeas.core.importexport.ImportException;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.security.AuthorizationRequestCache;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.token.exception.TokenException;
import org.silverpeas.core.security.token.exception.TokenRuntimeException;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.Mutable;

@Entity
@NamedQueries(value={@NamedQuery(name="calendarsByComponentInstanceIds", query="select c from Calendar c where c.componentInstanceId in :componentInstanceIds order by c.componentInstanceId, c.title, c.id"), @NamedQuery(name="synchronizedCalendars", query="select c from Calendar c where c.externalUrl is not null")})
@Table(name="sb_cal_calendar")
public class Calendar
extends SilverpeasJpaEntity<Calendar, UuidIdentifier>
implements Securable {
    private static final String MAIN_TITLE_REF = "###main###";
    @Column(name="instanceId", nullable=false)
    private String componentInstanceId;
    @Column(name="title", nullable=false)
    private String title;
    @Column(name="zoneId", nullable=false)
    private String zoneId;
    @Column(name="externalUrl")
    private String externalUrl;
    @Column(name="synchroDate")
    private Instant synchronizationDate;

    protected Calendar() {
    }

    public Calendar(String instanceId, String title) {
        this(instanceId, title, DisplayI18NHelper.getDefaultZoneId());
    }

    public Calendar(String instanceId, String title, ZoneId zoneId) {
        this.componentInstanceId = instanceId;
        this.title = title;
        this.zoneId = zoneId.toString();
    }

    public static Calendar newMainCalendar(SilverpeasComponentInstance instance) {
        return new Calendar(instance.getId(), MAIN_TITLE_REF);
    }

    public static Calendar getById(String id) {
        CalendarRepository calendarRepository = CalendarRepository.get();
        return (Calendar)calendarRepository.getById(id);
    }

    public static ComponentInstanceCalendars getByComponentInstanceId(String instanceId) {
        return ComponentInstanceCalendars.getByComponentInstanceId(instanceId);
    }

    public static List<Calendar> getByComponentInstanceIds(Collection<String> instanceIds) {
        CalendarRepository calendarRepository = CalendarRepository.get();
        return calendarRepository.getByComponentInstanceIds(instanceIds);
    }

    public static CalendarTimeWindow getTimeWindowBetween(LocalDate start, LocalDate end) {
        return new CalendarTimeWindow(start, end);
    }

    public static CalendarEvents getEvents() {
        return new CalendarEvents();
    }

    public static List<Calendar> getSynchronizedCalendars() {
        return CalendarRepository.get().getAllSynchronized();
    }

    @Override
    protected void performBeforePersist() {
        super.performBeforePersist();
        AuthorizationRequestCache.clear(this.getId());
    }

    @Override
    protected void performBeforeUpdate() {
        super.performBeforeUpdate();
        AuthorizationRequestCache.clear(this.getId());
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public String getTitle() {
        if (this.isMain()) {
            String cacheKey;
            SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
            Mutable mainTitle = Mutable.ofNullable((Object)((String)cache.get((Object)(cacheKey = MAIN_TITLE_REF + this.getId()), String.class)));
            if (!mainTitle.isPresent()) {
                SilverpeasComponentInstance.getById(this.getComponentInstanceId()).ifPresent(i -> {
                    if (i.isPersonal()) {
                        mainTitle.set((Object)((SilverpeasPersonalComponentInstance)i).getUser().getDisplayedName());
                    } else {
                        mainTitle.set((Object)i.getLabel());
                    }
                });
                cache.put((Object)cacheKey, mainTitle.get());
            }
            return (String)mainTitle.get();
        }
        return this.title;
    }

    public void setTitle(String title) {
        if (this.isMain()) {
            throw new IllegalArgumentException("not possible to set title on the main calendar of a component instance");
        }
        this.title = title;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.zoneId);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId.toString();
    }

    public URL getExternalCalendarUrl() {
        try {
            return new URL(this.externalUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setExternalCalendarUrl(URL calendarUrl) {
        this.externalUrl = calendarUrl.toString();
    }

    public Optional<Instant> getLastSynchronizationDate() {
        return Optional.ofNullable(this.synchronizationDate);
    }

    public boolean isSynchronized() {
        return this.externalUrl != null;
    }

    protected void setLastSynchronizationDate(Instant dateTime) {
        this.synchronizationDate = dateTime;
    }

    public void save() {
        if (!this.isPersisted() && this.isMain()) {
            Calendar.getByComponentInstanceId(this.getComponentInstanceId()).forEach(c -> {
                if (c.isMain()) {
                    throw new IllegalStateException(MessageFormat.format("instance {0} has already a main calendar", this.getComponentInstanceId()));
                }
            });
        }
        Transaction.performInOne(() -> {
            CalendarRepository calendarRepository = CalendarRepository.get();
            calendarRepository.save(this);
            return null;
        });
    }

    public void delete() {
        Transaction.performInOne(() -> {
            PersistentResourceToken.removeToken(CalendarReference.fromCalendar(this));
            this.clear();
            CalendarRepository calendarRepository = CalendarRepository.get();
            calendarRepository.delete(new Calendar[]{this});
            this.notify(ResourceEvent.Type.DELETION, this);
            return null;
        });
    }

    public CalendarTimeWindow in(Year year) {
        return this.between(year.atDay(1), year.atMonth(Month.DECEMBER).atEndOfMonth());
    }

    public CalendarTimeWindow in(YearMonth yearMonth) {
        return this.between(yearMonth.atDay(1), yearMonth.atEndOfMonth());
    }

    public CalendarTimeWindow in(LocalDate day) {
        return this.between(day, day);
    }

    public CalendarTimeWindow between(LocalDate start, LocalDate end) {
        this.verifyCalendarIsPersisted();
        return Calendar.getTimeWindowBetween(start, end).filter(f -> f.onCalendar(this));
    }

    private void verifyCalendarIsPersisted() {
        if (!this.isPersisted()) {
            throw new IllegalStateException("The calendar isn't persisted and then no action is available");
        }
    }

    public ICalendarImportResult synchronize() throws ImportException {
        return ICalendarEventSynchronization.get().synchronize(this);
    }

    public Optional<CalendarEvent> event(String eventId) {
        this.verifyCalendarIsPersisted();
        CalendarEventRepository repository = CalendarEventRepository.get();
        CalendarEvent event = (CalendarEvent)repository.getById(eventId);
        if (event != null && !event.getCalendar().getId().equals(this.getId())) {
            event = null;
        }
        return Optional.ofNullable(event);
    }

    public Optional<CalendarEvent> externalEvent(String externalEventId) {
        this.verifyCalendarIsPersisted();
        CalendarEventRepository repository = CalendarEventRepository.get();
        CalendarEvent event = repository.getByExternalId(this, externalEventId);
        return Optional.ofNullable(event);
    }

    public void clear() {
        this.verifyCalendarIsPersisted();
        Transaction.performInOne(() -> {
            CalendarEventRepository repository = CalendarEventRepository.get();
            repository.deleteAll(this);
            return null;
        });
    }

    public boolean isEmpty() {
        this.verifyCalendarIsPersisted();
        CalendarEventRepository repository = CalendarEventRepository.get();
        return repository.size(this) == 0L;
    }

    public boolean isMain() {
        return MAIN_TITLE_REF.equals(this.title);
    }

    public boolean isMainPersonalOf(User user) {
        return this.isMain() && this.isPersonalOf(user);
    }

    public boolean isPersonalOf(User user) {
        Optional<SilverpeasPersonalComponentInstance> instance = SilverpeasPersonalComponentInstance.getById(this.getComponentInstanceId());
        return instance.isPresent() && instance.get().getUser().getId().equals(user.getId());
    }

    public String getToken() {
        try {
            CalendarReference ref = CalendarReference.fromCalendar(this);
            return PersistentResourceToken.getOrCreateToken(ref).getValue();
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean canBeAccessedBy(User user) {
        return AuthorizationRequestCache.canBeAccessedBy(user, this.getId(), u -> ComponentAccessControl.get().isUserAuthorized(u.getId(), this.getComponentInstanceId()));
    }

    @Override
    public boolean canBeModifiedBy(User user) {
        return AuthorizationRequestCache.canBeModifiedBy(user, this.getId(), u -> {
            if (this.isMain()) {
                return false;
            }
            ComponentAccessControl componentAccessControl = ComponentAccessControl.get();
            Set<SilverpeasRole> roles = componentAccessControl.getUserRoles(u.getId(), this.getComponentInstanceId(), AccessControlContext.init().onOperationsOf(AccessControlOperation.MODIFICATION));
            return componentAccessControl.isUserAuthorized(roles) && Optional.ofNullable(SilverpeasRole.getHighestFrom(roles)).filter(r -> r.isGreaterThanOrEquals(SilverpeasRole.ADMIN)).isPresent();
        });
    }

    private void notify(ResourceEvent.Type type, Calendar ... events) {
        CalendarLifeCycleEventNotifier notifier = CalendarLifeCycleEventNotifier.get();
        notifier.notifyEventOn(type, events);
    }
}

