/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.annotation.constraint;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.silverpeas.core.annotation.constraint.DateRange;
import org.silverpeas.core.date.TemporalConverter;

public class DateRangeValidator
implements ConstraintValidator<DateRange, Object> {
    private String startDateFieldName;
    private String endDateFieldName;

    public void initialize(DateRange constraintAnnotation) {
        this.startDateFieldName = constraintAnnotation.start();
        this.endDateFieldName = constraintAnnotation.end();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        boolean isValid;
        try {
            Field startDateField = object.getClass().getDeclaredField(this.startDateFieldName);
            Field endDateField = object.getClass().getDeclaredField(this.endDateFieldName);
            startDateField.setAccessible(true);
            endDateField.setAccessible(true);
            Temporal startDate = (Temporal)startDateField.get(object);
            Temporal endDate = (Temporal)endDateField.get(object);
            isValid = startDate.getClass().equals(endDate.getClass());
            if (isValid) {
                if (startDate instanceof LocalDate && endDate instanceof LocalDate) {
                    LocalDate endLocalDate;
                    LocalDate startLocalDate = TemporalConverter.asLocalDate(startDate);
                    isValid = startLocalDate.isBefore(endLocalDate = TemporalConverter.asLocalDate(endDate)) || startLocalDate.isEqual(endLocalDate);
                } else {
                    OffsetDateTime startDateTime = TemporalConverter.asOffsetDateTime(startDate);
                    OffsetDateTime endDateTime = TemporalConverter.asOffsetDateTime(endDate);
                    isValid = startDateTime.isBefore(endDateTime);
                }
            }
        }
        catch (Exception ex) {
            isValid = false;
        }
        return isValid;
    }
}

