/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.plugins.index.FormattingUtils;

public class MetricsFormatter {
    private final JsopBuilder jsopBuilder = new JsopBuilder();
    private boolean isWritable = true;

    public static String createMetricsWithDurationOnly(Stopwatch taskStartWatch) {
        return MetricsFormatter.createMetricsWithDurationOnly(taskStartWatch.elapsed(TimeUnit.SECONDS));
    }

    public static String createMetricsWithDurationOnly(long totalDurationSeconds) {
        return MetricsFormatter.newBuilder().add("duration", FormattingUtils.formatToSeconds(totalDurationSeconds)).add("durationSeconds", totalDurationSeconds).build();
    }

    public static MetricsFormatter newBuilder() {
        return new MetricsFormatter();
    }

    private MetricsFormatter() {
        this.jsopBuilder.object();
    }

    public MetricsFormatter add(String key, String value) {
        Validate.checkState((boolean)this.isWritable, (Object)"Formatter already built, in read-only mode");
        this.jsopBuilder.key(key).value(value);
        return this;
    }

    public MetricsFormatter add(String key, int value) {
        Validate.checkState((boolean)this.isWritable, (Object)"Formatter already built, in read-only mode");
        this.jsopBuilder.key(key).value((long)value);
        return this;
    }

    public MetricsFormatter add(String key, long value) {
        Validate.checkState((boolean)this.isWritable, (Object)"Formatter already built, in read-only mode");
        this.jsopBuilder.key(key).value(value);
        return this;
    }

    public MetricsFormatter add(String key, boolean value) {
        Validate.checkState((boolean)this.isWritable, (Object)"Formatter already built, in read-only mode");
        this.jsopBuilder.key(key).value(value);
        return this;
    }

    public String build() {
        if (this.isWritable) {
            this.jsopBuilder.endObject();
            this.isWritable = false;
        }
        return this.jsopBuilder.toString();
    }
}

