/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.workflow;

import java.net.URI;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.workflow.ReplacementEntity;
import org.silverpeas.core.workflow.api.UserManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.ReplacementList;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Authorized
@Path(value="workflow/{workflowId}/replacements")
public class ReplacementResource
extends RESTWebService {
    private static final MessageFormat REPLACEMENT_BASE_URI = new MessageFormat("workflow/{0}/replacements");
    @PathParam(value="workflowId")
    private String workflowId;
    @Inject
    private UserManager userManager;
    private final Predicate<Replacement<?>> onTheRequester = r -> r.getSubstitute().getUserId().equals(this.getUser().getId()) || r.getIncumbent().getUserId().equals(this.getUser().getId());

    @GET
    @Produces(value={"application/json"})
    public <T extends Replacement<T>> Collection<ReplacementEntity> getAllReplacements(@QueryParam(value="incumbent") String incumbentId, @QueryParam(value="substitute") String substituteId) {
        Stream stream;
        if (StringUtil.isDefined((String)incumbentId) && StringUtil.isDefined((String)substituteId)) {
            User incumbent = this.getUser(incumbentId);
            User substitute = this.getUser(substituteId);
            ReplacementList replacements = Replacement.getAllWith((User)incumbent, (User)substitute, (String)this.workflowId);
            stream = this.filterOnTheRequester(replacements.stream());
        } else if (StringUtil.isDefined((String)incumbentId)) {
            User incumbent = this.getUser(incumbentId);
            ReplacementList replacements = Replacement.getAllOf((User)incumbent, (String)this.workflowId);
            stream = this.filterOnTheRequester(replacements.stream());
        } else if (StringUtil.isDefined((String)substituteId)) {
            User substitute = this.getUser(substituteId);
            ReplacementList replacements = Replacement.getAllBy((User)substitute, (String)this.workflowId);
            stream = this.filterOnTheRequester(replacements.stream());
        } else {
            stream = (Stream)this.process(() -> {
                ReplacementList replacements = Replacement.getAll((String)this.workflowId);
                return replacements.stream();
            }).lowestAccessRole(SilverpeasRole.SUPERVISOR).execute();
        }
        return this.encode(stream);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public ReplacementEntity getReplacement(@PathParam(value="id") String replacementId) {
        Object replacement = this.getReplacementById(replacementId);
        return ReplacementEntity.asWebEntity(replacement, this.getUri().getAbsolutePath());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public Response createNewReplacement(ReplacementEntity entity) {
        this.assertIsValid(entity);
        User incumbent = this.getUser(entity.getIncumbent().getId());
        User substitute = this.getUser(entity.getSubstitute().getId());
        Replacement replacement = Replacement.between((User)incumbent, (User)substitute).inWorkflow(this.workflowId).during(Period.between((LocalDate)entity.getStartDate(), (LocalDate)entity.getEndDate())).save();
        URI resourceURI = this.identifiedBy(new String[]{replacement.getId()});
        return Response.created((URI)resourceURI).entity((Object)ReplacementEntity.asWebEntity(replacement, resourceURI)).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public ReplacementEntity updateReplacement(@PathParam(value="id") String id, ReplacementEntity entity) {
        this.assertIsValid(entity);
        Object replacement = this.getReplacementById(id);
        if (!replacement.getIncumbent().getUserId().equals(entity.getIncumbent().getId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Replacement updatedReplacement = replacement.setSubstitute(this.getUser(entity.getSubstitute().getId())).setPeriod(Period.between((LocalDate)entity.getStartDate(), (LocalDate)entity.getEndDate())).save();
        return ReplacementEntity.asWebEntity(updatedReplacement, this.getUri().getAbsolutePath());
    }

    @DELETE
    @Path(value="{id}")
    @Transactional
    public void deleteReplacement(@PathParam(value="id") String replacementId) {
        Object replacement = this.getReplacementById(replacementId);
        replacement.delete();
    }

    protected String getResourceBasePath() {
        return REPLACEMENT_BASE_URI.format(new Object[]{this.workflowId});
    }

    public String getComponentId() {
        return this.workflowId;
    }

    private User getUser(String userId) {
        try {
            return this.userManager.getUser("me".equals(userId) ? this.getUser().getId() : userId);
        }
        catch (WorkflowException e) {
            throw new WebApplicationException("User " + userId + " doesn't exist", Response.Status.NOT_FOUND);
        }
    }

    private <T extends Replacement<T>> T getReplacementById(String id) {
        Optional optionalReplacement = Replacement.get((String)id);
        Replacement replacement = (Replacement)optionalReplacement.orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        this.assertIsValid(replacement);
        return (T)replacement;
    }

    private boolean isRequesterSupervisor() {
        return Stream.of(this.userManager.getUsersInRole(SilverpeasRole.SUPERVISOR.getName(), this.workflowId)).anyMatch(u -> u.getUserId().equals(this.getUser().getId()));
    }

    private <T extends Replacement<T>> Stream<T> filterOnTheRequester(Stream<T> replacements) {
        return this.isRequesterSupervisor() ? replacements : replacements.filter(this.onTheRequester);
    }

    private <T extends Replacement<T>> List<ReplacementEntity> encode(Stream<T> replacements) {
        return replacements.map(r -> ReplacementEntity.asWebEntity(r, this.identifiedBy(new String[]{r.getId()}))).collect(Collectors.toList());
    }

    private void assertIsValid(ReplacementEntity entity) {
        if (entity.getIncumbent() == null || entity.getSubstitute() == null || entity.getStartDate() == null || entity.getEndDate() == null || !this.workflowId.equals(entity.getWorkflowInstanceId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRequesterSupervisor() && !entity.getIncumbent().getId().equals(this.getUser().getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private void assertIsValid(Replacement<?> replacement) {
        if (!this.workflowId.equals(replacement.getWorkflowInstanceId())) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.onTheRequester.test(replacement) && !this.isRequesterSupervisor()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }
}

