/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.subscribe;

import java.util.Collections;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.comment.CommentRuntimeException;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.GroupSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanProvider;
import org.silverpeas.core.webapi.subscribe.AbstractSubscriptionResource;

@WebService
@Path(value="unsubscribe/{componentId}")
@Authorized
public class UnsubscribeResource
extends AbstractSubscriptionResource {
    static final String PATH = "unsubscribe";

    @POST
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromComponent() {
        return this.unsubscribeUserFromComponent(this.getUser().getId());
    }

    @POST
    @Path(value="user/{userId}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromComponent(@PathParam(value="userId") String userId) {
        return this.unsubscribeSubscriberFromResource(CommonSubscriptionResourceConstants.COMPONENT, (SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId), null);
    }

    @POST
    @Path(value="group/{groupId}")
    @Produces(value={"application/json"})
    public Response unsubscribeGroupFromComponent(@PathParam(value="groupId") String groupId) {
        return this.unsubscribeSubscriberFromResource(CommonSubscriptionResourceConstants.COMPONENT, (SubscriptionSubscriber)GroupSubscriptionSubscriber.from((String)groupId), null);
    }

    @POST
    @Path(value="{subscriptionType}/{id}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromResource(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String id) {
        return this.unsubscribeUserFromResource(subscriptionType, id, this.getUser().getId());
    }

    @POST
    @Path(value="{subscriptionType}/{id}/user/{userId}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromResource(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String id, @PathParam(value="userId") String userId) {
        return this.unsubscribeSubscriberFromResource(this.decodeSubscriptionResourceType(subscriptionType), (SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId), id);
    }

    @POST
    @Path(value="{subscriptionType}/{id}/group/{groupId}")
    @Produces(value={"application/json"})
    public Response unsubscribeGroupFromResource(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String id, @PathParam(value="groupId") String groupId) {
        return this.unsubscribeSubscriberFromResource(this.decodeSubscriptionResourceType(subscriptionType), (SubscriptionSubscriber)GroupSubscriptionSubscriber.from((String)groupId), id);
    }

    private Response unsubscribeSubscriberFromResource(SubscriptionResourceType subscriptionResourceType, SubscriptionSubscriber subscriber, String resourceId) {
        try {
            Subscription subscription = this.getSubscription(subscriber, subscriptionResourceType, resourceId);
            SubscriptionServiceProvider.getSubscribeService().unsubscribe(subscription);
            String userLanguage = this.getUserPreferences().getLanguage();
            SubscriptionBeanProvider.getBySubscription(subscription, userLanguage).ifPresent(b -> WebMessager.getInstance().addSuccess(this.getBundle().getString("GML.unsubscribe.success"), b.getPath()));
            return Response.ok(Collections.singletonList("OK")).build();
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected String getResourceBasePath() {
        return PATH;
    }
}

