/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.subscribe;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.constant.SubscriptionMethod;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanProvider;
import org.silverpeas.core.webapi.subscribe.SubscriberEntity;
import org.silverpeas.core.webapi.subscribe.SubscriptionResourceEntity;

@XmlRootElement
public class SubscriptionEntity {
    @XmlElement(required=true)
    private SubscriptionResourceEntity resource;
    @XmlElement(required=true)
    private SubscriberEntity subscriber;
    @XmlElement(defaultValue="true")
    private boolean forced = true;
    @XmlElement(defaultValue="true")
    private boolean selfCreation = true;
    @XmlElement(defaultValue="true")
    private Date creationDate;
    @XmlElement
    private boolean enabled = true;

    static SubscriptionEntity from(Subscription subscription) {
        AbstractSubscriptionBean bean = SubscriptionEntity.decorate(subscription);
        SubscriptionEntity entity = new SubscriptionEntity();
        entity.resource = SubscriptionResourceEntity.from(subscription.getResource());
        entity.subscriber = SubscriberEntity.from(subscription.getSubscriber());
        entity.forced = SubscriptionMethod.FORCED.equals((Object)subscription.getSubscriptionMethod());
        entity.selfCreation = SubscriptionMethod.SELF_CREATION.equals((Object)subscription.getSubscriptionMethod());
        entity.creationDate = subscription.getCreationDate();
        entity.enabled = bean.isValid();
        return entity;
    }

    public SubscriptionResourceEntity getResource() {
        return this.resource;
    }

    public SubscriberEntity getSubscriber() {
        return this.subscriber;
    }

    public boolean isForced() {
        return this.forced;
    }

    public boolean isSelfCreation() {
        return this.selfCreation;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static AbstractSubscriptionBean decorate(Subscription subscription) {
        AbstractSubscriptionBean bean = subscription instanceof AbstractSubscriptionBean ? (AbstractSubscriptionBean)subscription : SubscriptionBeanProvider.getBySubscription(subscription, null).orElseThrow(() -> new IllegalArgumentException("Type of subscription not supported: " + subscription.getResource().getType()));
        return bean;
    }
}

