/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.socialnetwork.invitation;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.socialnetwork.invitation.Invitation;
import org.silverpeas.core.socialnetwork.invitation.InvitationService;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.socialnetwork.invitation.InvitationEntity;

@RequestScoped
@Path(value="invitations")
@Authenticated
public class InvitationResource
extends RESTWebService {
    static final String PATH = "invitations";
    @Inject
    private InvitationService invitationService;

    @Path(value="inbox")
    @GET
    @Produces(value={"application/json"})
    public List<InvitationEntity> getReceivedInvitations() {
        List invitations = this.invitationService.getAllMyInvitationsReceive(Integer.parseInt(this.getUser().getId()));
        return this.asWebEntities(invitations, InvitationResource.locatedAt(this.getUri().getAbsolutePathBuilder()));
    }

    @Path(value="outbox")
    @GET
    @Produces(value={"application/json"})
    public List<InvitationEntity> getSentInvitations() {
        List invitations = this.invitationService.getAllMyInvitationsSent(Integer.parseInt(this.getUser().getId()));
        return this.asWebEntities(invitations, InvitationResource.locatedAt(this.getUri().getAbsolutePathBuilder()));
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public InvitationEntity getInvitation(@PathParam(value="id") Integer id) {
        this.checkInvitation(id);
        Invitation invitation = this.invitationService.getInvitation(id.intValue());
        return this.asWebEntity(invitation, InvitationResource.locatedAt(this.getUri().getAbsolutePathBuilder()));
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelInvitation(@PathParam(value="id") Integer id) {
        this.checkInvitation(id);
        this.invitationService.ignoreInvitation(id.intValue());
        return Response.ok().build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response acceptInvitation(@PathParam(value="id") Integer id) {
        this.checkInvitation(id);
        int code = this.invitationService.acceptInvitation(id.intValue());
        if (code == -1) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (code == -2) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInvitation(InvitationEntity invitationEntity) {
        this.checkInvitationEntity(invitationEntity);
        Invitation invitation = new Invitation();
        invitation.setReceiverId(invitationEntity.getReceiverId());
        invitation.setMessage(invitationEntity.getMessage());
        invitation.setSenderId(Integer.parseInt(this.getUser().getId()));
        int id = this.invitationService.invite(invitation);
        invitationEntity.setId(id);
        return Response.ok((Object)((Object)invitationEntity)).build();
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return null;
    }

    private void checkInvitationEntity(InvitationEntity invitationEntity) {
        int receiverId;
        int senderId = Integer.parseInt(this.getUser().getId());
        if (senderId == (receiverId = invitationEntity.getReceiverId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private void checkInvitation(int invitationId) {
        Invitation invitation = this.invitationService.getInvitation(invitationId);
        if (invitation == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (invitation.getSenderId() != Integer.parseInt(this.getUser().getId()) && invitation.getReceiverId() != Integer.parseInt(this.getUser().getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private static UriBuilder locatedAt(UriBuilder uri) {
        return uri;
    }

    private List<InvitationEntity> asWebEntities(List<Invitation> invitations, UriBuilder baseUri) {
        baseUri.path("{invitationId}");
        return invitations.stream().map(invitation -> InvitationEntity.fromInvitation(invitation).withAsUri(baseUri.build(new Object[]{invitation.getId()}))).collect(Collectors.toList());
    }

    private InvitationEntity asWebEntity(Invitation invitation, UriBuilder baseUri) {
        baseUri.path("{invitationId}");
        return InvitationEntity.fromInvitation(invitation).withAsUri(baseUri.build(new Object[]{invitation.getId()}));
    }
}

