/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.selection;

import java.net.URI;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.selection.SelectionContext;
import org.silverpeas.core.selection.SelectionEntry;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.selection.BasketItem;
import org.silverpeas.kernel.exception.NotFoundException;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SelectionBasketEntry
implements WebEntity {
    private URI uri;
    @XmlElement(required=true)
    private BasketItem item;
    private SelectionContext context = new SelectionContext(SelectionContext.Reason.TRANSFER);

    public static SelectionBasketEntry from(SelectionEntry<SilverpeasResource> entry) {
        Objects.requireNonNull(entry);
        SilverpeasResource resource = entry.getResource();
        BasketItem item = BasketItem.from(resource);
        return new SelectionBasketEntry(item, entry.getContext());
    }

    protected SelectionBasketEntry() {
    }

    public SelectionBasketEntry(BasketItem item, SelectionContext context) {
        this.item = item;
        this.context = context;
    }

    public SelectionBasketEntry(BasketItem item) {
        this.item = item;
        this.context = new SelectionContext(SelectionContext.Reason.TRANSFER);
    }

    public URI getURI() {
        return this.uri;
    }

    public SelectionBasketEntry withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public BasketItem getItem() {
        return this.item;
    }

    public SelectionContext getContext() {
        return this.context;
    }

    public SelectionBasketEntry reload() {
        String language = User.getCurrentRequester().getUserPreferences().getLanguage();
        try {
            Object resource = this.getItem().toResource();
            if (resource instanceof I18nContribution) {
                LocalizedContribution contribution = ((I18nContribution)resource).getLocalizationIn(language);
                this.item = BasketItem.from((SilverpeasResource)contribution);
            } else {
                this.item = BasketItem.from(resource);
            }
            return this;
        }
        catch (NotFoundException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectionBasketEntry that = (SelectionBasketEntry)o;
        return this.item.equals(that.item);
    }

    public int hashCode() {
        return Objects.hash(this.item);
    }
}

