/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.pdc.PdcClassificationEntity;
import org.silverpeas.core.webapi.pdc.PdcPositionDeletionException;
import org.silverpeas.core.webapi.pdc.PdcPositionEntity;
import org.silverpeas.core.webapi.pdc.PdcServiceProvider;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="pdc/classification/{componentId:[a-zA-Z]+[0-9]+}/{contentId}")
@Authorized
public class PdcClassificationResource
extends RESTWebService {
    static final String PATH = "pdc/classification";
    @Inject
    private PdcServiceProvider pdcServiceProvider;
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="contentId")
    private String contentId;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    protected String getContentId() {
        return this.contentId;
    }

    @GET
    @Produces(value={"application/json"})
    public PdcClassificationEntity getPdCClassification() {
        try {
            URI itsURI = this.getUri().getRequestUri();
            return this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI));
        }
        catch (ContentManagerException | PdcException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex);
            throw new WebApplicationException(ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @DELETE
    @Path(value="{positionId}")
    public void deletePdcPosition(@PathParam(value="positionId") int positionId) {
        try {
            this.pdcServiceProvider().deletePosition(positionId, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
        }
        catch (PdcPositionDeletionException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)((Object)ex));
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        catch (ContentManagerException | PdcException ex) {
            SilverLogger.getLogger((Object)((Object)this)).warn(ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addPdcPosition(PdcPositionEntity newPosition) {
        if (newPosition.getPositionValues().isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ClassifyPosition position = newPosition.toClassifyPosition();
            this.pdcServiceProvider().addPosition(position, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
            String positionId = String.valueOf(position.getPositionId());
            URI newPositionURI = this.getUri().getAbsolutePathBuilder().path(positionId).build(new Object[0]);
            URI itsURI = this.getUri().getAbsolutePath();
            return Response.created((URI)newPositionURI).entity((Object)this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI))).build();
        }
        catch (ContentManagerException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (PdcException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{positionId}")
    public PdcClassificationEntity updatePdcPosition(@PathParam(value="positionId") String positionId, PdcPositionEntity modifiedPosition) {
        if (!positionId.equals(modifiedPosition.getId()) || modifiedPosition.getPositionValues().isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ClassifyPosition position = modifiedPosition.toClassifyPosition();
            this.pdcServiceProvider().updatePosition(position, PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
            URI itsURI = this.getUri().getWebResourcePathBuilder().path("{contentId}").build(new Object[]{this.getContentId()});
            return this.thePdcClassificationOfTheRequestedResource(PdcClassificationResource.identifiedBy(itsURI));
        }
        catch (ContentManagerException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (PdcException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private PdcClassificationEntity thePdcClassificationOfTheRequestedResource(URI uri) throws SilverpeasException {
        UserPreferences userPreferences = this.getUserPreferences();
        List<ClassifyPosition> contentPositions = this.pdcServiceProvider().getAllPositions(PdcServiceProvider.forContentOfId(this.getContentId()), PdcServiceProvider.inComponentOfId(this.getComponentId()));
        PdcClassificationEntity theClassificationEntity = PdcClassificationEntity.aPdcClassificationEntity(PdcClassificationEntity.fromPositions(contentPositions), PdcClassificationEntity.inLanguage(userPreferences.getLanguage()), PdcClassificationEntity.atURI(uri));
        if (userPreferences.isThesaurusEnabled()) {
            UserThesaurusHolder theUserThesaurus = this.pdcServiceProvider().getThesaurusOfUser(UserDetail.from((User)this.getUser()));
            theClassificationEntity.withSynonymsFrom(theUserThesaurus);
        }
        return theClassificationEntity;
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private static URI identifiedBy(URI uri) {
        return uri;
    }
}

