/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.mylinks;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.mylinks.MyLinksWebManager;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MyLinkEntity
implements WebEntity {
    private static final long serialVersionUID = -4596241423551371699L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    @NotNull
    private int linkId;
    @XmlElement(defaultValue="-1")
    private int position = -1;
    @XmlElement
    @NotNull
    private String name;
    @XmlElement
    private String description;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String url;
    @XmlElement(defaultValue="false")
    @NotNull
    private boolean visible = false;
    @XmlElement(defaultValue="false")
    @NotNull
    private boolean popup = false;
    @XmlElement
    private String userId;
    @XmlElement
    private String instanceId;
    @XmlElement
    private String objectId;
    @XmlElement
    private Integer categoryId;

    public static MyLinkEntity fromLinkDetail(LinkDetail link, URI uri) {
        return new MyLinkEntity(link, uri);
    }

    protected MyLinkEntity() {
    }

    public MyLinkEntity(LinkDetail link, URI uri) {
        this.uri = uri;
        this.name = link.getName();
        this.description = link.getDescription();
        this.url = link.getUrl();
        this.linkId = link.getLinkId();
        this.position = link.hasPosition() ? link.getPosition() : -1;
        this.visible = link.isVisible();
        this.popup = link.isPopup();
        this.userId = link.getUserId();
        this.instanceId = link.getInstanceId();
        this.objectId = link.getObjectId();
        this.categoryId = link.getCategory() != null ? Integer.valueOf(link.getCategory().getId()) : null;
    }

    public URI getURI() {
        return this.uri;
    }

    public LinkDetail toLinkDetail() {
        LinkDetail linkDetail = new LinkDetail(this.name, this.description, this.url, this.visible, this.popup);
        linkDetail.setInstanceId(this.instanceId);
        linkDetail.setObjectId(this.objectId);
        linkDetail.setUserId(this.userId);
        linkDetail.setLinkId(this.linkId);
        if (this.position != -1) {
            linkDetail.setHasPosition(true);
            linkDetail.setPosition(this.position);
        } else {
            linkDetail.setHasPosition(false);
        }
        if (this.categoryId != null) {
            linkDetail.setCategory(MyLinksWebManager.get().getAuthorizedCategory(String.valueOf(this.categoryId)));
        }
        return linkDetail;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public int getPosition() {
        return this.position;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }
}

