/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.documenttemplate;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.documenttemplate.DocumentTemplateRestrictionFilter;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.documenttemplate.DocumentTemplateEntity;
import org.silverpeas.core.webapi.documenttemplate.DocumentTemplateResourceURIs;
import org.silverpeas.core.webapi.documenttemplate.DocumentTemplateWebManager;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="documentTemplates")
@Authenticated
public class DocumentTemplateResource
extends RESTWebService {
    @Inject
    private DocumentTemplateWebManager manager;
    @Inject
    private DocumentTemplateResourceURIs uri;
    @QueryParam(value="instanceIdFilter")
    private String instanceIdFilter;

    protected String getResourceBasePath() {
        return "documentTemplates";
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public DocumentTemplateEntity get(@PathParam(value="id") String id) {
        return this.asWebEntity(this.manager.getDocumentTemplate(id));
    }

    @GET
    @Produces(value={"application/json"})
    public List<DocumentTemplateEntity> listAll() {
        this.checkUserCanAccessInstanceIdIfAny();
        DocumentTemplateRestrictionFilter filter = new DocumentTemplateRestrictionFilter().setInstanceId(this.instanceIdFilter);
        return this.asWebEntities(this.manager.getAllDocumentTemplates().stream().filter(arg_0 -> ((DocumentTemplateRestrictionFilter)filter).applyOn(arg_0)));
    }

    private List<DocumentTemplateEntity> asWebEntities(Stream<DocumentTemplate> docTemplates) {
        return docTemplates.map(this::asWebEntity).collect(Collectors.toList());
    }

    private DocumentTemplateEntity asWebEntity(DocumentTemplate docTemplate) {
        return DocumentTemplateEntity.from(docTemplate, this.uri.ofDocumentTemplate(docTemplate), this.getHttpRequest().getUserLanguage());
    }

    private void checkUserCanAccessInstanceIdIfAny() {
        if (StringUtil.isDefined((String)this.instanceIdFilter) && !ComponentAccessControl.get().isUserAuthorized(this.getUser().getId(), (Object)this.instanceIdFilter)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public String getComponentId() {
        return null;
    }
}

