/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CalendarEntity
implements WebEntity {
    private URI uri;
    @XmlElement
    private URI icalPublicUri;
    @XmlElement
    private URI icalPrivateUri;
    private String id;
    private String title;
    private String zoneId;
    private URI externalUrl;
    private boolean main;
    private boolean userMainPersonal;
    private boolean userPersonal;
    private String ownerName;
    private Date createDate;
    private Date lastUpdateDate;
    private boolean canBeModified;
    private boolean canBeDeleted;

    protected CalendarEntity() {
    }

    public static CalendarEntity fromCalendar(Calendar calendar) {
        return new CalendarEntity().decorate(calendar);
    }

    public CalendarEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public CalendarEntity withICalPublicURI(URI uri) {
        this.icalPublicUri = uri;
        return this;
    }

    public CalendarEntity withICalPrivateURI(URI uri) {
        this.icalPrivateUri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    protected void setUri(URI uri) {
        this.withURI(uri);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public URI getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(URI externalUrl) {
        this.externalUrl = externalUrl;
    }

    @XmlElement
    public boolean isMain() {
        return this.main;
    }

    @XmlElement
    public boolean isUserMainPersonal() {
        return this.userMainPersonal;
    }

    @XmlElement
    public boolean isUserPersonal() {
        return this.userPersonal;
    }

    @XmlElement
    public String getOwnerName() {
        return this.ownerName;
    }

    @XmlElement
    public Date getCreateDate() {
        return this.createDate;
    }

    @XmlElement
    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @XmlElement
    public boolean canBeModified() {
        return this.canBeModified;
    }

    @XmlElement
    public boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    protected <T extends CalendarEntity> T decorate(Calendar calendar) {
        User currentUser = User.getCurrentRequester();
        this.id = calendar.getId();
        this.title = calendar.getTitle();
        this.zoneId = calendar.getZoneId().toString();
        try {
            this.externalUrl = calendar.getExternalCalendarUrl() != null ? calendar.getExternalCalendarUrl().toURI() : null;
        }
        catch (URISyntaxException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        this.main = calendar.isMain();
        this.userMainPersonal = calendar.isMainPersonalOf(currentUser);
        this.userPersonal = calendar.isPersonalOf(currentUser);
        this.ownerName = calendar.getCreator().getDisplayedName();
        this.createDate = calendar.getCreationDate();
        this.lastUpdateDate = calendar.getLastUpdateDate();
        this.canBeModified = calendar.canBeModifiedBy(currentUser);
        this.canBeDeleted = calendar.canBeDeletedBy(currentUser);
        return (T)this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("uri", (Object)this.getURI());
        builder.append("id", (Object)this.getId());
        builder.append("title", (Object)this.getTitle());
        builder.append("zoneId", (Object)this.getZoneId());
        builder.append("externalUrl", (Object)this.getExternalUrl());
        return builder.toString();
    }

    public Calendar merge(Calendar calendar) {
        calendar.setTitle(this.getTitle());
        if (this.getExternalUrl() != null) {
            try {
                calendar.setExternalCalendarUrl(this.getExternalUrl().toURL());
            }
            catch (MalformedURLException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        if (!StringUtil.isDefined((String)this.getZoneId())) {
            throw new WebApplicationException("zoneId must exist into calendar attributes", Response.Status.NOT_ACCEPTABLE);
        }
        calendar.setZoneId(ZoneId.of(this.getZoneId()));
        return calendar;
    }
}

