/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class MapTag
extends TagSupport {
    private static final long serialVersionUID = 1425756234498404463L;
    private String spaceId;
    private boolean displayAppIcon;
    private boolean displayAppsFirst;
    private String callbackJSForMainSpace;
    private String callbackJSForApps;
    private String callbackJSForSubspaces;
    private boolean megaMenu = false;
    private Boolean forceHidingComponents;
    private boolean skipSubSpaces = false;
    private boolean skipComponents = false;

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public boolean isDisplayAppIcon() {
        return this.displayAppIcon;
    }

    public void setDisplayAppIcon(boolean displayAppIcon) {
        this.displayAppIcon = displayAppIcon;
    }

    public boolean isDisplayAppsFirst() {
        return this.displayAppsFirst;
    }

    public void setDisplayAppsFirst(boolean displayAppsFirst) {
        this.displayAppsFirst = displayAppsFirst;
    }

    public String getCallbackJSForMainSpace() {
        return this.callbackJSForMainSpace;
    }

    public void setCallbackJSForMainSpace(String callbackJSForMainSpace) {
        this.callbackJSForMainSpace = callbackJSForMainSpace;
    }

    public String getCallbackJSForApps() {
        return this.callbackJSForApps;
    }

    public void setCallbackJSForApps(String callbackJSForApps) {
        this.callbackJSForApps = callbackJSForApps;
    }

    public String getCallbackJSForSubspaces() {
        return this.callbackJSForSubspaces;
    }

    public void setCallbackJSForSubspaces(String callbackJSForSubspaces) {
        this.callbackJSForSubspaces = callbackJSForSubspaces;
    }

    public boolean isMegaMenu() {
        return this.megaMenu;
    }

    public void setMegaMenu(boolean megaMenu) {
        this.megaMenu = megaMenu;
    }

    public void setForceHidingComponents(Boolean forceHidingComponents) {
        this.forceHidingComponents = forceHidingComponents;
    }

    public boolean isSkipSubSpaces() {
        return this.skipSubSpaces;
    }

    public void setSkipSubSpaces(boolean skipSubSpaces) {
        this.skipSubSpaces = skipSubSpaces;
    }

    public boolean isSkipComponents() {
        return this.skipComponents;
    }

    public void setSkipComponents(boolean skipComponents) {
        this.skipComponents = skipComponents;
    }

    public int doStartTag() throws JspException {
        try {
            LookHelper helper = LookHelper.getLookHelper(this.pageContext.getSession());
            boolean showHiddenComponents = helper.getSettings("display.all.components", false);
            if (this.forceHidingComponents != null) {
                boolean bl = showHiddenComponents = this.forceHidingComponents == false;
            }
            if (StringUtil.isNotDefined((String)this.spaceId)) {
                SpaceWithSubSpacesAndComponents root = OrganizationControllerProvider.getOrganisationController().getFullTreeview(helper.getUserId());
                for (SpaceWithSubSpacesAndComponents space : root.getSubSpaces()) {
                    this.pageContext.getOut().print(this.printSpaceAndSubSpaces(space, showHiddenComponents));
                }
            } else {
                SpaceWithSubSpacesAndComponents space = OrganizationControllerProvider.getOrganisationController().getFullTreeview(helper.getUserId(), this.spaceId);
                this.pageContext.getOut().print(this.printSpaceAndSubSpaces(space, showHiddenComponents));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            throw new JspException("Can't display the site map", (Throwable)e);
        }
        return 0;
    }

    private String printSpaceAndSubSpaces(SpaceWithSubSpacesAndComponents space, boolean showHiddenComponents) {
        MainSessionController sessionController = this.getMainSessionController();
        SpaceInstLight spaceInst = space.getSpace();
        StringBuilder result = new StringBuilder(500);
        if (spaceInst != null) {
            String subspaces;
            String language = sessionController.getFavoriteLanguage();
            String spaceHref = this.getSpaceHREF(spaceInst);
            String hasMegaMenuLI = "";
            String megaMenuUL = "";
            if (this.isMegaMenu() && spaceInst.isRoot()) {
                hasMegaMenuLI = "has-mega-menu";
                megaMenuUL = "mega-menu";
            }
            result.append("<li class=\"space " + hasMegaMenuLI + "\" id=\"space-").append(spaceInst.getId()).append("\">");
            result.append(spaceHref).append(spaceInst.getName(language));
            result.append("</a>\n");
            result.append(this.getSpaceDescription(spaceInst, language));
            String apps = this.isSkipComponents() ? "" : this.printApps(space, showHiddenComponents);
            String string = subspaces = this.isSkipSubSpaces() ? "" : this.printSubspaces(space, showHiddenComponents);
            if (StringUtil.isDefined((String)apps) || StringUtil.isDefined((String)subspaces)) {
                result.append("<ul class=\"" + megaMenuUL + "\">");
                if (this.displayAppsFirst) {
                    result.append(apps);
                    result.append("<li class=\"clear\"></li>");
                }
                result.append(subspaces);
                if (!this.displayAppsFirst) {
                    result.append(apps);
                }
                result.append("</ul>\n");
            }
        }
        return result.toString();
    }

    private String getSpaceDescription(SpaceInstLight spaceInst, String language) {
        if (this.isMegaMenu() && !spaceInst.isRoot() && StringUtil.isDefined((String)spaceInst.getDescription(language))) {
            return "<p class=\"megaMenu-spaceDescription\">" + spaceInst.getDescription(language) + "</p>";
        }
        return "";
    }

    private String getSpaceHREF(SpaceInstLight spaceInst) {
        String spaceHref = "<a class=\"sp-link\" href=\"" + URLUtil.getSimpleURL((int)0, (String)spaceInst.getId()) + "\" target=\"_top\">";
        if (spaceInst.isRoot() && StringUtil.isDefined((String)this.getCallbackJSForMainSpace())) {
            spaceHref = "<a href=\"javascript:" + this.getCallbackJSForMainSpace() + "('" + spaceInst.getId() + "');\">";
        } else if (!spaceInst.isRoot() && StringUtil.isDefined((String)this.getCallbackJSForSubspaces())) {
            spaceHref = "<a href=\"javascript:" + this.getCallbackJSForSubspaces() + "('" + spaceInst.getId() + "');\">";
        }
        return spaceHref;
    }

    private String printSubspaces(SpaceWithSubSpacesAndComponents space, boolean showHiddenComponents) {
        StringBuilder result = new StringBuilder(500);
        for (SpaceWithSubSpacesAndComponents subSpace : space.getSubSpaces()) {
            result.append(this.printSpaceAndSubSpaces(subSpace, showHiddenComponents));
        }
        return result.toString();
    }

    private String printApps(SpaceWithSubSpacesAndComponents space, boolean showHiddenComponents) {
        StringBuilder result = new StringBuilder(500);
        MainSessionController sessionController = this.getMainSessionController();
        String language = sessionController.getFavoriteLanguage();
        int nbApp = 0;
        for (SilverpeasComponentInstance componentInst : space.getComponents()) {
            ++nbApp;
            if (componentInst.isHidden() && !showHiddenComponents) continue;
            String label = componentInst.getLabel(language);
            result.append("<li class=\"app num").append(nbApp).append("\" id=\"app-").append(componentInst.getId()).append("\">");
            if (this.displayAppIcon) {
                result.append("<img src=\"").append(ComponentInstLight.getIcon((SilverpeasComponentInstance)componentInst, (boolean)false)).append("\"");
                result.append(" border=\"0\" alt=\"\"/>");
            }
            String href = "<a class=\"sp-link\" href=\"" + URLUtil.getSimpleURL((int)1, (String)componentInst.getId()) + "\" target=\"_top\">";
            if (StringUtil.isDefined((String)this.getCallbackJSForApps())) {
                href = "<a href=\"javascript:" + this.getCallbackJSForApps() + "('" + componentInst.getId() + "');\">";
            }
            result.append(href).append(label).append("</a>\n");
            if (this.isMegaMenu() && StringUtil.isDefined((String)componentInst.getDescription(language))) {
                result.append("<p class=\"megaMenu-appDescription\">" + componentInst.getDescription(language) + "</p>");
            }
            result.append("</li>");
        }
        return result.toString();
    }

    private MainSessionController getMainSessionController() {
        return (MainSessionController)this.pageContext.getSession().getAttribute("SilverSessionController");
    }
}

