/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.list;

import java.io.Serializable;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.div;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.list.AbstractListPaneTag;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.util.StringUtil;

public class ListPaneTag
extends AbstractListPaneTag {
    private static final long serialVersionUID = 1370094709020971998L;
    private int numberLinesPerPage = 10;
    private PaginationPage page;

    @Override
    public int doStartTag() throws JspException {
        this.initNbLinesPerPage();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        Pagination currentPagination = this.getPagination(this.getNbItems());
        String baseUrl = this.getRoutingAddress();
        StringBuilder url = new StringBuilder(baseUrl);
        if (baseUrl.indexOf(63) < 0) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("PaginationPaneIndex").append("=");
        currentPagination.setBaseURL(url.toString());
        div listPane = new div();
        if (StringUtil.isDefined((String)this.getId())) {
            listPane.setID(this.getId());
        }
        listPane.setClass("list-pane");
        div paginationNav = new div();
        paginationNav.setClass("list-pane-nav");
        paginationNav.addElement(currentPagination.print());
        listPane.addElement(this.getBodyContent().getString());
        listPane.addElement((Element)paginationNav);
        new ElementContainer().addElement((Element)listPane).output((Writer)this.pageContext.getOut());
        return 6;
    }

    public void setNumberLinesPerPage(int numberLinesPerPage) {
        this.numberLinesPerPage = numberLinesPerPage;
    }

    public void setPage(PaginationPage page) {
        this.page = page;
    }

    Pagination getPagination(int nbItems) {
        String cacheKey = ((Object)((Object)this)).getClass().getSimpleName() + "pagination" + this.getVar();
        Pagination pagination = (Pagination)this.getRequest().getAttribute(cacheKey);
        if (pagination == null) {
            GraphicElementFactory gef = this.getGraphicElementFactory();
            pagination = gef.getPagination(nbItems, this.getState().getMaximumVisibleLine(), this.getState().getFirstVisibleLine());
            this.getRequest().setAttribute(cacheKey, (Object)pagination);
        } else {
            if (nbItems < this.getState().getFirstVisibleLine()) {
                this.getState().setFirstVisibleLine(0);
            }
            pagination.init(nbItems, this.getState().getMaximumVisibleLine(), this.getState().getFirstVisibleLine());
        }
        return pagination;
    }

    private void initNbLinesPerPage() {
        String index;
        String nbLines = this.getRequest().getParameter("ItemsPerPage");
        if (StringUtil.isDefined((String)nbLines)) {
            this.getState().setMaximumVisibleLine(Integer.parseInt(nbLines));
        }
        if (StringUtil.isDefined((String)(index = this.getRequest().getParameter("PaginationPaneIndex")))) {
            this.getState().setFirstVisibleLine(Integer.parseInt(index));
        }
    }

    State getState() {
        String sessionKey = ((Object)((Object)this)).getClass().getSimpleName() + this.getVar();
        State state = (State)this.getSession().getAttribute(sessionKey);
        if (state == null) {
            state = new State(this.numberLinesPerPage);
            this.getSession().setAttribute(sessionKey, (Object)state);
        }
        if (this.page != null) {
            state.setFirstVisibleLine((this.page.getPageNumber() - 1) * this.page.getPageSize());
            state.setMaximumVisibleLine(this.page.getPageSize());
        }
        return state;
    }

    private GraphicElementFactory getGraphicElementFactory() {
        return (GraphicElementFactory)this.getSession().getAttribute("SessionGraphicElementFactory");
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 879525429823439845L;
        private int maximumVisibleLine;
        private int firstVisibleLine = 0;

        public State(int maximumVisibleLine) {
            this.maximumVisibleLine = maximumVisibleLine;
        }

        int getFirstVisibleLine() {
            return this.firstVisibleLine;
        }

        void setFirstVisibleLine(int firstVisibleLine) {
            this.firstVisibleLine = firstVisibleLine;
        }

        int getMaximumVisibleLine() {
            return this.maximumVisibleLine;
        }

        void setMaximumVisibleLine(int maximumVisibleLine) {
            this.maximumVisibleLine = maximumVisibleLine;
        }
    }
}

