/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.socialnetwork.user.model;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;

public class SNFullUser {
    private UserFull userFull;
    private String profilPhoto;
    private String duration;
    private boolean connected;
    private String phone;

    public SNFullUser(String userId) {
        this.userFull = OrganizationControllerProvider.getOrganisationController().getUserFull(userId);
        this.phone = this.userFull.getValue("phone");
        String avatar = this.userFull.getLogin() + ".jpg";
        File image = new File(FileRepositoryManager.getAbsolutePath((String)"avatar") + File.separatorChar + avatar);
        this.profilPhoto = image.exists() ? "/display/avatar/" + avatar : "/directory/jsp/icons/Photo_profil.jpg";
        SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
        Collection sessionInfos = sessionManagement.getConnectedUsersList();
        for (SessionInfo varSi : sessionInfos) {
            if (!varSi.getUserDetail().getId().equals(userId)) continue;
            this.duration = DateUtil.formatDuration((long)(new Date().getTime() - varSi.getOpeningTimestamp()));
            this.connected = true;
            return;
        }
        this.duration = "";
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getProfilPhoto() {
        return this.profilPhoto;
    }

    public UserFull getUserFull() {
        return this.userFull;
    }

    public String getPhone() {
        return this.phone;
    }
}

