/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.security.SecuritySettings;
import org.silverpeas.core.web.util.HttpMethod;
import org.silverpeas.kernel.util.StringUtil;

public class WebCORSFilter
implements Filter {
    private static final String ALL_DOMAINS_ALLOWED = "*";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("X-Frame-Options", "SAMEORIGIN");
        httpResponse.addHeader("Access-Control-Allow-Origin", this.getAllowedDomain(httpRequest));
        if (HttpMethod.OPTIONS.name().equals(httpRequest.getMethod())) {
            httpResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
            httpResponse.addHeader("Access-Control-Allow-Headers", "Content-Type, X-Silverpeas-Session, Authorization");
        }
        chain.doFilter(request, response);
    }

    private String getAllowedDomain(HttpServletRequest httpRequest) {
        String serverOrigin;
        List allowedDomains = SecuritySettings.getAllowedDomains();
        String allowedDomain = allowedDomains.contains(ALL_DOMAINS_ALLOWED) ? ALL_DOMAINS_ALLOWED : (StringUtil.isDefined((String)(serverOrigin = httpRequest.getHeader("Origin"))) && allowedDomains.contains(serverOrigin) ? serverOrigin : URLUtil.getServerURL((HttpServletRequest)httpRequest));
        return allowedDomain;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

