/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.tagcloud.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.tagcloud.dao.TagCloudDAO;
import org.silverpeas.core.tagcloud.dao.TagCloudPK;
import org.silverpeas.core.tagcloud.model.TagCloud;
import org.silverpeas.core.tagcloud.model.TagCloudUtil;
import org.silverpeas.core.tagcloud.model.comparator.TagCloudByCountComparator;
import org.silverpeas.core.tagcloud.model.comparator.TagCloudByNameComparator;
import org.silverpeas.core.tagcloud.service.TagCloudRuntimeException;
import org.silverpeas.core.tagcloud.service.TagCloudService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultTagCloudService
implements TagCloudService,
ComponentInstanceDeletion {
    private Connection openConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createTagCloud(TagCloud tagCloud) {
        Connection con = this.openConnection();
        try {
            TagCloudDAO.createTagCloud(con, tagCloud);
        }
        catch (SQLException e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.createTagCloud()", 4, "tagCloud.CREATING_NEW_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteTagCloud(TagCloudPK pk, int type) {
        Connection con = this.openConnection();
        try {
            TagCloudDAO.deleteTagCloud(con, pk, type);
        }
        catch (SQLException e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.deleteTagCloud()", 4, "tagCloud.DELETE_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<TagCloud> getInstanceTagClouds(String instanceId) {
        return this.getInstanceTagClouds(instanceId, -1);
    }

    @Override
    public Collection<TagCloud> getInstanceTagClouds(String instanceId, int maxCount) {
        Connection con = this.openConnection();
        try {
            Collection<TagCloud> tagClouds = TagCloudDAO.getInstanceTagClouds(con, instanceId);
            List<TagCloud> tagList = new ArrayList<TagCloud>(tagClouds.size());
            if (!tagClouds.isEmpty()) {
                Iterator<TagCloud> iter = tagClouds.iterator();
                tagList.add(iter.next());
                while (iter.hasNext()) {
                    TagCloud iterTagCloud = iter.next();
                    String iterTag = iterTagCloud.getTag();
                    boolean tagExists = false;
                    for (int i = 0; i < tagList.size() && !tagExists; ++i) {
                        TagCloud currentTagCloud = tagList.get(i);
                        if (!currentTagCloud.getTag().equals(iterTag)) continue;
                        tagExists = true;
                        currentTagCloud.incrementCount();
                    }
                    if (tagExists) continue;
                    tagList.add(iterTagCloud);
                }
                if (maxCount > 0 && tagList.size() > maxCount) {
                    Collections.sort(tagList, new TagCloudByCountComparator());
                    tagList = tagList.subList(0, maxCount);
                    Collections.sort(tagList, new TagCloudByNameComparator());
                }
            }
            ArrayList<TagCloud> arrayList = tagList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getInstanceTagClouds()", 4, "tagCloud.GET_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<TagCloud> getElementTagClouds(TagCloudPK pk) {
        Connection con = this.openConnection();
        try {
            Collection<TagCloud> collection = TagCloudDAO.getElementTagClouds(con, pk);
            return collection;
        }
        catch (Exception e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getElementTagClouds()", 4, "tagCloud.GET_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<TagCloud> getTagCloudsByTags(String tags, String instanceId, int type) {
        Connection con = this.openConnection();
        try {
            Collection<TagCloud> collection = TagCloudDAO.getTagCloudsByTags(con, TagCloudUtil.getTag(tags), instanceId, type);
            return collection;
        }
        catch (Exception e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getTagCloudsByTags()", 4, "tagCloud.GET_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<TagCloud> getTagCloudsByElement(String instanceId, String externalId, int type) {
        Connection con = this.openConnection();
        try {
            Collection<TagCloud> collection = TagCloudDAO.getTagCloudsByElement(con, instanceId, externalId, type);
            return collection;
        }
        catch (Exception e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getTagCloudsByElement()", 4, "tagCloud.GET_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public String getTagsByElement(TagCloudPK pk) {
        Connection con = this.openConnection();
        try {
            String string = TagCloudDAO.getTagsByElement(con, pk);
            return string;
        }
        catch (Exception e) {
            throw new TagCloudRuntimeException("DefaultTagCloudService.getTagsByElement()", 4, "tagCloud.GET_TAGCLOUD_FAILED", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            TagCloudDAO.deleteAllTagClouds(connection, componentInstanceId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

