/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.interests.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.pdc.classification.Criteria;
import org.silverpeas.core.pdc.interests.model.Interests;
import org.silverpeas.core.pdc.interests.service.InterestsDAOException;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class InterestsDAO {
    public static final String INTERESTS_AXES_TABLE_NAME = "SB_Interests_Axis";
    public static final String DATE_FORMAT = "yyyy/MM/dd";
    public static final String GET_IC_BY_USERID_QUERY = "SELECT a.id, a.name, a.criteria, a.workSpaceId, a.peasId,  a.authorId, a.afterDate, a.beforeDate, a.ownerId FROM SB_Interests a WHERE a.ownerId = ? ";
    public static final String GET_IC_BY_PK_QUERY = "SELECT id, name, criteria, workSpaceId, peasId, authorId, afterDate, beforeDate, ownerId FROM SB_Interests WHERE id = ? ";
    public static final String CREATE_IC_QUERY = "INSERT  INTO SB_Interests (id, name, criteria, workSpaceId, peasId, authorId, afterDate, beforeDate, ownerId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    public static final String UPDATE_IC_QUERY = "UPDATE SB_Interests SET name = ?, criteria = ?, workSpaceId = ?, peasId = ?, authorId = ?, afterDate = ?, beforeDate = ?, ownerId = ? WHERE id = ?";
    public static final String REMOVE_IC_BY_PKS_LIST_QUERY = "DELETE FROM SB_Interests WHERE id = ?";
    public static final String LOAD_PDC_PK_QUERY = "SELECT a.axisId, a.value   FROM SB_Interests_Axis a WHERE a.icId = ? ";
    public static final String CREATE_PDC_CONTEXT_QUERY = "INSERT  INTO SB_Interests_Axis (  id, icId, axisId, value) VALUES (?, ?, ?, ?) ";
    public static final String REMOVE_IC_CONTEXT_QUERY = "delete from SB_Interests_Axis where icId = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Interests> getInterestsByUserID(Connection con, int userid) throws SQLException, InterestsDAOException {
        ArrayList<Interests> arrayList;
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.getInterestsByUserId", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(GET_IC_BY_USERID_QUERY);
            prepStmt.setInt(1, userid);
            ArrayList<Interests> result = new ArrayList<Interests>();
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                Interests ic = InterestsDAO.getInterestsfromResultSet(rs, con);
                result.add(ic);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interests getInterestsByPK(Connection con, int icID) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.getInterestsByPK", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        Interests result = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(GET_IC_BY_PK_QUERY);
            prepStmt.setInt(1, icID);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                result = InterestsDAO.getInterestsfromResultSet(rs, con);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    private static Interests getInterestsfromResultSet(ResultSet rs, Connection con) throws SQLException, InterestsDAOException {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        Interests ic = new Interests();
        ic.setId(rs.getInt(1));
        ic.setName(rs.getString(2));
        ic.setQuery(rs.getString(3));
        ic.setWorkSpaceID(rs.getString(4));
        ic.setPeasID(rs.getString(5));
        ic.setAuthorID(rs.getString(6));
        try {
            String afterDate = rs.getString(7);
            String beforeDate = rs.getString(8);
            if (afterDate != null && !afterDate.isEmpty()) {
                ic.setAfterDate(formatter.parse(afterDate));
            } else {
                ic.setAfterDate(null);
            }
            if (beforeDate == null || beforeDate.isEmpty()) {
                ic.setBeforeDate(null);
            } else {
                ic.setBeforeDate(formatter.parse(beforeDate));
            }
        }
        catch (ParseException e) {
            throw new InterestsDAOException("InterestsDAO.getInterestsfromResultSet", "root.EX_CANT_PARSE_DATE", e);
        }
        ic.setOwnerID(rs.getInt(9));
        List<Criteria> pdcContext = InterestsDAO.loadPdcContext(con, ic.getId());
        ic.setPdcContext(pdcContext);
        return ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveInterests(Connection con, Interests interests) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.createInterests", "root.EX_CONNECTION_OPEN_FAILED");
        }
        if (interests == null) {
            throw new InterestsDAOException("InterestsDAO.createInterests", "Pdc.CANNOT_CREATE_INTEREST_CENTER");
        }
        PreparedStatement prepStmt = null;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        int newId = -1;
        try {
            newId = DBUtil.getNextId((String)"SB_Interests", (String)"Id");
        }
        catch (Exception e) {
            throw new InterestsDAOException("InterestsDAO.createInterests", "root.EX_PK_GENERATION_FAILED", "SB_Interests", e);
        }
        try {
            prepStmt = con.prepareStatement(CREATE_IC_QUERY);
            prepStmt.setInt(1, newId);
            prepStmt.setString(2, interests.getName());
            prepStmt.setString(3, interests.getQuery());
            prepStmt.setString(4, interests.getWorkSpaceID());
            prepStmt.setString(5, interests.getPeasID());
            prepStmt.setString(6, interests.getAuthorID());
            if (interests.getAfterDate() != null) {
                prepStmt.setString(7, formatter.format(interests.getAfterDate()));
            } else {
                prepStmt.setString(7, "");
            }
            if (interests.getBeforeDate() != null) {
                prepStmt.setString(8, formatter.format(interests.getBeforeDate()));
            } else {
                prepStmt.setString(8, "");
            }
            prepStmt.setInt(9, interests.getOwnerID());
            int result = prepStmt.executeUpdate();
            if (result < 1) {
                throw new InterestsDAOException("InterestsDAO.createInterests", "Pdc.CANNOT_CREATE_INTEREST_CENTER", "ID: " + newId + ". DataObject: " + interests);
            }
            List<? extends Criteria> list = interests.getPdcContext();
            if (list != null && !list.isEmpty()) {
                InterestsDAO.appendPdcContext(con, list, newId);
            }
            interests.setId(newId);
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateInterests(Connection con, Interests interests) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.updateInterests", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        try {
            prepStmt = con.prepareStatement(UPDATE_IC_QUERY);
            prepStmt.setInt(9, interests.getId());
            prepStmt.setString(1, interests.getName());
            prepStmt.setString(2, interests.getQuery());
            prepStmt.setString(3, interests.getWorkSpaceID());
            prepStmt.setString(4, interests.getPeasID());
            prepStmt.setString(5, interests.getAuthorID());
            if (interests.getAfterDate() != null) {
                prepStmt.setString(6, formatter.format(interests.getAfterDate()));
            } else {
                prepStmt.setString(6, "");
            }
            if (interests.getBeforeDate() != null) {
                prepStmt.setString(7, formatter.format(interests.getBeforeDate()));
            } else {
                prepStmt.setString(7, "");
            }
            prepStmt.setInt(8, interests.getOwnerID());
            int result = prepStmt.executeUpdate();
            if (result < 1) {
                throw new InterestsDAOException("InterestsDAO.updateInterests", "Pdc.CANNOT_UPDATE_INTEREST_CENTER", interests.toString());
            }
            List<? extends Criteria> list = interests.getPdcContext();
            if (list != null && !list.isEmpty()) {
                InterestsDAO.updatePdcContext(con, list, interests.getId());
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void removeInterestsByPK(Connection con, List<Integer> removePKList) throws SQLException, InterestsDAOException {
        for (Integer pk : removePKList) {
            InterestsDAO.removeInterestsByPK(con, pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInterestsByPK(Connection con, int removeID) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.removeInterestsById", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(REMOVE_IC_BY_PKS_LIST_QUERY);
            prepStmt.setInt(1, removeID);
            int result = prepStmt.executeUpdate();
            if (result < 1) {
                throw new InterestsDAOException("InterestsDAO.removeInterestsById", "Pdc.CANNOT_DELETE_INTEREST_CENTER", "ID=" + removeID);
            }
            InterestsDAO.removePdcContext(con, removeID);
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Criteria> loadPdcContext(Connection con, int icId) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.loadPdcContext", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Criteria> result = null;
        try {
            prepStmt = con.prepareStatement(LOAD_PDC_PK_QUERY);
            prepStmt.setInt(1, icId);
            result = new ArrayList<Criteria>();
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int axisId = rs.getInt(1);
                String value = rs.getString(2);
                Criteria sc = new Criteria(axisId, value);
                result.add(sc);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] appendPdcContext(Connection con, List<? extends Criteria> pdcContext, int icId) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.appendPdcContext", "root.EX_CONNECTION_OPEN_FAILED");
        }
        if (pdcContext == null) {
            return null;
        }
        PreparedStatement prepStmt = null;
        int[] generatedPKs = null;
        try {
            prepStmt = con.prepareStatement(CREATE_PDC_CONTEXT_QUERY);
            generatedPKs = new int[pdcContext.size()];
            for (int i = 0; i < pdcContext.size(); ++i) {
                Criteria criteria = pdcContext.get(i);
                int newId = -1;
                try {
                    newId = DBUtil.getNextId((String)INTERESTS_AXES_TABLE_NAME, (String)"Id");
                }
                catch (Exception e) {
                    throw new InterestsDAOException("InterestsDAO.appendPdcContext", "root.EX_PK_GENERATION_FAILED", INTERESTS_AXES_TABLE_NAME, e);
                }
                prepStmt.setInt(1, newId);
                prepStmt.setInt(2, icId);
                prepStmt.setInt(3, criteria.getAxisId());
                prepStmt.setString(4, criteria.getValue());
                int result = prepStmt.executeUpdate();
                if (result < 1) {
                    throw new InterestsDAOException("InterestsDAO.appendPdcContext", "Pdc.CANNOT_CREATE_INTEREST_CENTER_PDC", "Criteria: " + criteria + ". ID = " + newId + ". For Interests ID = " + icId);
                }
                generatedPKs[i] = newId;
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return generatedPKs;
    }

    public static void updatePdcContext(Connection con, List<? extends Criteria> list, int icId) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.updatePdcContext", "root.EX_CONNECTION_OPEN_FAILED");
        }
        if (icId < 0) {
            throw new InterestsDAOException("InterestsDAO.updatePdcContext", "root.EX_INVALID_ARG", String.valueOf(icId));
        }
        InterestsDAO.removePdcContext(con, icId);
        InterestsDAO.appendPdcContext(con, list, icId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePdcContext(Connection con, int icId) throws SQLException, InterestsDAOException {
        if (con == null) {
            throw new InterestsDAOException("InterestsDAO.removePdcContext", "root.EX_CONNECTION_OPEN_FAILED");
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(REMOVE_IC_CONTEXT_QUERY);
            prepStmt.setInt(1, icId);
            int n = prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }
}

