/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.chat.ChatServerException;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class ChatUser
extends UserDetail {
    private static final long serialVersionUID = 3020578029905358343L;
    private final User user;

    private ChatUser(User user) {
        this.user = user;
    }

    public static ChatUser getById(String userId) {
        return new ChatUser(User.getById((String)userId));
    }

    public static ChatUser getCurrentRequester() {
        return new ChatUser(User.getCurrentRequester());
    }

    public static ChatUser fromUser(User user) {
        if (user instanceof ChatUser) {
            return (ChatUser)user;
        }
        return new ChatUser(user);
    }

    public String getChatId() {
        String xmppDomain = this.getChatDomain();
        return this.getChatLogin() + "@" + xmppDomain;
    }

    public String getChatLogin() {
        String chatLogin = StringUtil.normalizeByRemovingAccent((String)this.getLogin().toLowerCase());
        int idx = chatLogin.indexOf("@");
        if (idx > 0) {
            ChatSettings.JidFormatPolicy policy = ChatSettings.get().getJidFormatPolicy();
            switch (policy) {
                case REMOVED: {
                    chatLogin = chatLogin.substring(0, idx);
                    break;
                }
                case SPECIFIC_CODE: {
                    chatLogin = chatLogin.replace("@", "0x40").replace("/", "0x2f");
                    break;
                }
                default: {
                    throw new SilverpeasRuntimeException("Invalid policy");
                }
            }
            byte[] bytes = chatLogin.getBytes(Charsets.UTF_8);
            if (bytes.length > 1023) {
                chatLogin = new String(Arrays.copyOf(bytes, 1022), Charsets.UTF_8);
            }
        }
        return chatLogin.replaceAll("\\s", "");
    }

    public String getChatPassword() {
        return this.getToken();
    }

    public String getChatDomain() {
        ChatSettings settings = ChatServer.getChatSettings();
        return settings.getMappedXmppDomain(this.getDomainId());
    }

    public boolean isChatEnabled() {
        ChatSettings settings = ChatServer.getChatSettings();
        String domainId = this.getChatDomain();
        if (!settings.isChatEnabled() || domainId.isEmpty()) {
            return false;
        }
        List<String> allowedGroupIds = settings.getAllowedUserGroups();
        if (!allowedGroupIds.isEmpty()) {
            String[] groupIds = OrganizationController.get().getAllGroupIdsOfUser(this.user.getId());
            return Stream.of(groupIds).anyMatch(allowedGroupIds::contains);
        }
        return true;
    }

    public boolean isRegistered() {
        try {
            return this.isChatEnabled() && ChatServer.get().isUserExisting((User)this);
        }
        catch (ChatServerException e) {
            return false;
        }
    }

    public boolean isAtLeastInOneGroup(List<String> groupIds) {
        String[] actualGroupIds = ChatUser.getOrganisationController().getAllGroupIdsOfUser(this.getId());
        return Stream.of(actualGroupIds).anyMatch(groupIds::contains);
    }

    public String getId() {
        return this.user.getId();
    }

    public String getDomainId() {
        return this.user.getDomainId();
    }

    public boolean isDomainRestricted() {
        return this.user.isDomainRestricted();
    }

    public boolean isDomainAdminRestricted() {
        return this.user.isDomainAdminRestricted();
    }

    public String getLogin() {
        return this.user.getLogin();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public String getEmailAddress() {
        return this.user.getEmailAddress();
    }

    public Date getCreationDate() {
        return this.user.getCreationDate();
    }

    public Date getSaveDate() {
        return this.user.getSaveDate();
    }

    public int getVersion() {
        return this.user.getVersion();
    }

    public Date getStateSaveDate() {
        return this.user.getStateSaveDate();
    }

    public boolean isFullyDefined() {
        return this.user.isFullyDefined();
    }

    public String getDisplayedName() {
        return this.user.getDisplayedName();
    }

    public UserAccessLevel getAccessLevel() {
        return this.user.getAccessLevel();
    }

    public boolean isAnonymous() {
        return this.user.isAnonymous();
    }

    public boolean isSystem() {
        return this.user.isSystem();
    }

    public boolean isBlanked() {
        return this.user.isBlanked();
    }

    public boolean isAccessAdmin() {
        return this.user.isAccessAdmin();
    }

    public boolean isAccessDomainManager() {
        return this.user.isAccessDomainManager();
    }

    public boolean isAccessPdcManager() {
        return this.user.isAccessPdcManager();
    }

    public boolean isAccessUser() {
        return this.user.isAccessUser();
    }

    public boolean isAccessGuest() {
        return this.user.isAccessGuest();
    }

    public boolean isAccessUnknown() {
        return this.user.isAccessUnknown();
    }

    public boolean isPlayingAdminRole(String instanceId) {
        return this.user.isPlayingAdminRole(instanceId);
    }

    public UserState getState() {
        return this.user.getState();
    }

    public boolean isActivatedState() {
        return this.user.isActivatedState();
    }

    public boolean isValidState() {
        return this.user.isValidState();
    }

    public boolean isDeletedState() {
        return this.user.isDeletedState();
    }

    public boolean isRemovedState() {
        return this.user.isRemovedState();
    }

    public boolean isBlockedState() {
        return this.user.isBlockedState();
    }

    public boolean isDeactivatedState() {
        return this.user.isDeactivatedState();
    }

    public boolean isExpiredState() {
        return this.user.isExpiredState();
    }

    public boolean isConnected() {
        return this.user.isConnected();
    }

    public UserPreferences getUserPreferences() {
        return this.user.getUserPreferences();
    }

    public String getAvatar() {
        return this.user.getAvatar();
    }

    public String getSmallAvatar() {
        return this.user.getSmallAvatar();
    }

    public String getStatus() {
        return this.user.getStatus();
    }

    public long getDurationOfCurrentSession() {
        return this.user.getDurationOfCurrentSession();
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

