/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.webactiv.calendar.model.Category;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class CategoryDAO {
    public static final String CATEGORYCOLUMNNAMES = "CalendarCategory.categoryId, CalendarCategory.name";

    public static Category getCategoryFromResultSet(ResultSet rs) throws SQLException {
        String categoryId = rs.getString(1);
        String name = rs.getString(2);
        Category result = new Category(categoryId, name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getJournalCategories(Connection con, String journalId) throws SQLException {
        ArrayList<Category> arrayList;
        String selectStatement = "select CalendarCategory.categoryId, CalendarCategory.name from CalendarCategory, CalendarJournalCategory  where journalId = ? and CalendarCategory.categoryId = CalendarJournalCategory.categoryId";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Category> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, new Integer(journalId));
            rs = prepStmt.executeQuery();
            list = new ArrayList<Category>();
            while (rs.next()) {
                Category category = CategoryDAO.getCategoryFromResultSet(rs);
                list.add(category);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Category getCategory(Connection con, String categoryId) throws SQLException {
        Category category;
        String selectStatement = "select CalendarCategory.categoryId, CalendarCategory.name from CalendarCategory  where categoryId = ? ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            Category category2 = null;
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, categoryId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                category2 = CategoryDAO.getCategoryFromResultSet(rs);
            }
            category = category2;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAllCategories(Connection con) throws SQLException {
        String selectStatement = "select CalendarCategory.categoryId, CalendarCategory.name from CalendarCategory ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Category> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            rs = prepStmt.executeQuery();
            list = new ArrayList<Category>();
            while (rs.next()) {
                Category category = CategoryDAO.getCategoryFromResultSet(rs);
                list.add(category);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJournalCategory(Connection con, String journalId, String categoryId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String insertStatement = "insert into CalendarJournalCategory (journalId, categoryId)  values (?, ?)";
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setInt(1, new Integer(journalId));
            prepStmt.setString(2, categoryId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJournalCategory(Connection con, String journalId, String categoryId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String statement = "delete from CalendarJournalCategory where journalId = ? and categoryId = ?";
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, new Integer(journalId));
            prepStmt.setString(2, categoryId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJournal(Connection con, String id) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String statement = "delete from CalendarJournalCategory where journalId = ?";
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, new Integer(id));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }
}

